/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.user.search;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.UserFilter;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UserSearchParams {
    public static final UserSearchParams ACTIVE_USERS_IGNORE_EMPTY_QUERY = new UserSearchParams(false, true, false, false, null, null);
    public static final UserSearchParams ACTIVE_USERS_ALLOW_EMPTY_QUERY = new UserSearchParams(true, true, false, false, null, null);
    private final boolean allowEmptyQuery;
    private final boolean includeActive;
    private final boolean includeInactive;
    private final boolean canMatchEmail;
    private final UserFilter userFilter;
    private final Set<Long> projectIds;
    @Nonnull
    private final Predicate<User> postProcessingFilter;
    private final Integer maxResults;

    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive) {
        this(allowEmptyQuery, includeActive, includeInactive, false, null, null);
    }

    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, (Predicate<User>)Predicates.alwaysTrue());
    }

    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, Predicate<User> postProcessingFilter) {
        this(allowEmptyQuery, includeActive, includeInactive, canMatchEmail, userFilter, projectIds, postProcessingFilter, null);
    }

    public UserSearchParams(boolean allowEmptyQuery, boolean includeActive, boolean includeInactive, boolean canMatchEmail, UserFilter userFilter, Set<Long> projectIds, Predicate<User> postProcessingFilter, Integer maxResults) {
        this.allowEmptyQuery = allowEmptyQuery;
        this.includeActive = includeActive;
        this.includeInactive = includeInactive;
        this.canMatchEmail = canMatchEmail;
        this.userFilter = userFilter;
        this.projectIds = projectIds;
        this.postProcessingFilter = postProcessingFilter == null ? Predicates.alwaysTrue() : postProcessingFilter;
        this.maxResults = maxResults;
    }

    public boolean allowEmptyQuery() {
        return this.allowEmptyQuery;
    }

    public boolean includeActive() {
        return this.includeActive;
    }

    public boolean includeInactive() {
        return this.includeInactive;
    }

    public boolean canMatchEmail() {
        return this.canMatchEmail;
    }

    public UserFilter getUserFilter() {
        return this.userFilter;
    }

    public Set<Long> getProjectIds() {
        return this.projectIds;
    }

    @Nonnull
    public Predicate<User> getPostProcessingFilter() {
        return this.postProcessingFilter;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UserSearchParams prototype) {
        return new Builder(prototype);
    }

    public static class Builder {
        private boolean allowEmptyQuery = false;
        private boolean includeActive = true;
        private boolean includeInactive = false;
        private boolean canMatchEmail = false;
        private UserFilter userFilter = null;
        private Set<Long> projectIds = null;
        private Predicate<User> postProcessingFilter;
        private Integer maxResults;

        public Builder() {
        }

        private Builder(UserSearchParams prototype) {
            this.allowEmptyQuery = prototype.allowEmptyQuery;
            this.includeActive = prototype.includeActive;
            this.includeInactive = prototype.includeInactive;
            this.canMatchEmail = prototype.canMatchEmail;
            this.userFilter = prototype.userFilter;
            this.projectIds = prototype.projectIds;
            this.postProcessingFilter = prototype.postProcessingFilter;
            this.maxResults = prototype.maxResults;
        }

        public UserSearchParams build() {
            return new UserSearchParams(this.allowEmptyQuery, this.includeActive, this.includeInactive, this.canMatchEmail, this.userFilter, this.projectIds, this.postProcessingFilter, this.maxResults);
        }

        public Builder allowEmptyQuery(boolean allowEmptyQuery) {
            this.allowEmptyQuery = allowEmptyQuery;
            return this;
        }

        public Builder includeActive(boolean includeActive) {
            this.includeActive = includeActive;
            return this;
        }

        public Builder includeInactive(boolean includeInactive) {
            this.includeInactive = includeInactive;
            return this;
        }

        public Builder canMatchEmail(boolean canMatchEmail) {
            this.canMatchEmail = canMatchEmail;
            return this;
        }

        public Builder filter(UserFilter userFilter) {
            this.userFilter = userFilter;
            return this;
        }

        public Builder filterByProjectIds(Collection<Long> projectIds) {
            this.projectIds = projectIds == null ? null : ImmutableSet.copyOf(projectIds);
            return this;
        }

        public Builder filter(Predicate<User> postProcessingFilter) {
            this.postProcessingFilter = postProcessingFilter;
            return this;
        }

        public Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }
    }
}

