/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectCreationData;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface ProjectService {
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_KEY = "projectKey";
    public static final String PROJECT_LEAD = "projectLead";
    public static final String PROJECT_URL = "projectUrl";
    public static final String PROJECT_DESCRIPTION = "projectDescription";
    public static final int MAX_NAME_LENGTH = 80;
    public static final int MIN_NAME_LENGTH = 2;
    public static final int MAX_KEY_LENGTH = 10;
    public static final int DEFAULT_NAME_LENGTH = 80;

    @Nonnull
    public CreateProjectValidationResult validateCreateProject(ApplicationUser var1, @Nonnull ProjectCreationData var2);

    public Project createProject(CreateProjectValidationResult var1);

    public ServiceResult validateUpdateProject(ApplicationUser var1, String var2);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6, Long var7);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, ApplicationUser var5, String var6, Long var7);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, Project var2, String var3, String var4, String var5, ApplicationUser var6, String var7, Long var8, Long var9);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, Project var2, String var3, String var4, String var5, String var6, String var7, Long var8, Long var9);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, String var5, String var6, Long var7, Long var8);

    public UpdateProjectValidationResult validateUpdateProject(ApplicationUser var1, String var2, String var3, String var4, ApplicationUser var5, String var6, Long var7, Long var8);

    public Project updateProject(UpdateProjectValidationResult var1);

    public Either<Project, ErrorCollection> updateProjectType(ApplicationUser var1, Project var2, ProjectTypeKey var3);

    public DeleteProjectValidationResult validateDeleteProject(ApplicationUser var1, String var2);

    public DeleteProjectResult deleteProject(ApplicationUser var1, DeleteProjectValidationResult var2);

    public UpdateProjectSchemesValidationResult validateUpdateProjectSchemes(ApplicationUser var1, Long var2, Long var3, Long var4);

    public void updateProjectSchemes(UpdateProjectSchemesValidationResult var1, Project var2);

    public boolean isValidAllProjectData(JiraServiceContext var1, ProjectCreationData var2);

    public boolean isValidRequiredProjectData(JiraServiceContext var1, ProjectCreationData var2);

    public boolean isValidProjectKey(JiraServiceContext var1, String var2);

    public String getProjectKeyDescription();

    public GetProjectResult getProjectById(Long var1);

    public GetProjectResult getProjectById(ApplicationUser var1, Long var2);

    public GetProjectResult getProjectByIdForAction(ApplicationUser var1, Long var2, ProjectAction var3);

    public GetProjectResult getProjectByKey(String var1);

    public GetProjectResult getProjectByKey(ApplicationUser var1, String var2);

    public int getMaximumNameLength();

    public GetProjectResult getProjectByKeyForAction(ApplicationUser var1, String var2, ProjectAction var3);

    public int getMaximumKeyLength();

    public long getProjectCount();

    public ServiceOutcome<List<Project>> getAllProjects(ApplicationUser var1);

    public ServiceOutcome<List<Project>> getAllProjectsForAction(ApplicationUser var1, ProjectAction var2);

    @PublicApi
    public static class DeleteProjectResult
    extends ServiceResultImpl {
        @Internal
        public DeleteProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }
    }

    @PublicApi
    public static class DeleteProjectValidationResult
    extends AbstractProjectResult {
        @Internal
        public DeleteProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public DeleteProjectValidationResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection, project);
        }
    }

    @PublicApi
    public static class GetProjectResult
    extends AbstractProjectResult {
        @Internal
        public GetProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public GetProjectResult(Project project) {
            super(new SimpleErrorCollection(), project);
        }

        @Internal
        public GetProjectResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection, project);
        }
    }

    @PublicApi
    public static abstract class AbstractProjectResult
    extends ServiceResultImpl
    implements ServiceOutcome<Project> {
        private Project project;

        @Internal
        public AbstractProjectResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public AbstractProjectResult(ErrorCollection errorCollection, Project project) {
            super(errorCollection);
            this.project = project;
        }

        public Project getProject() {
            return this.project;
        }

        @Override
        public Project get() {
            return this.project;
        }

        @Override
        public Project getReturnedValue() {
            return this.project;
        }
    }

    @PublicApi
    public static class UpdateProjectValidationResult
    extends AbstractProjectValidationResult {
        private final Project originalProject;

        @Internal
        public UpdateProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.originalProject = null;
        }

        @Deprecated
        @Internal
        public UpdateProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId, Project originalProject) {
            this(errorCollection, name, key, description, lead, url, assigneeType, avatarId, originalProject, false, null);
        }

        @Internal
        public UpdateProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String lead, String url, Long assigneeType, Long avatarId, Project originalProject, boolean keyChanged, ApplicationUser user) {
            super(errorCollection, name, key, description, lead, url, assigneeType, avatarId, keyChanged, user);
            this.originalProject = originalProject;
        }

        public Project getOriginalProject() {
            return this.originalProject;
        }
    }

    @PublicApi
    public static class CreateProjectValidationResult
    extends ServiceResultImpl {
        private final ApplicationUser user;
        private final ProjectCreationData projectCreationData;

        @Internal
        public CreateProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.user = null;
            this.projectCreationData = null;
        }

        @Internal
        public CreateProjectValidationResult(ErrorCollection errorCollection, ApplicationUser user, ProjectCreationData projectCreationData) {
            super(errorCollection);
            this.user = user;
            this.projectCreationData = projectCreationData;
        }

        public ProjectCreationData getProjectCreationData() {
            return this.projectCreationData;
        }

        public ApplicationUser getUser() {
            return this.user;
        }
    }

    @PublicApi
    public static abstract class AbstractProjectValidationResult
    extends ServiceResultImpl {
        private final String name;
        private final String key;
        private final String description;
        private final String leadName;
        private final String url;
        private final Long assigneeType;
        private final Long avatarId;
        private final boolean keyChanged;
        private final ApplicationUser user;

        @Internal
        public AbstractProjectValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
            this.name = null;
            this.key = null;
            this.description = null;
            this.leadName = null;
            this.url = null;
            this.assigneeType = null;
            this.avatarId = null;
            this.keyChanged = false;
            this.user = null;
        }

        @Internal
        public AbstractProjectValidationResult(ErrorCollection errorCollection, String name, String key, String description, String leadName, String url, Long assigneeType, Long avatarId, boolean keyChanged, ApplicationUser user) {
            super(errorCollection);
            this.name = name;
            this.key = key;
            this.description = description;
            this.leadName = leadName;
            this.url = url;
            this.assigneeType = assigneeType;
            this.avatarId = avatarId;
            this.keyChanged = keyChanged;
            this.user = user;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLeadUsername() {
            return this.leadName;
        }

        public String getLead() {
            return this.leadName;
        }

        public String getUrl() {
            return this.url;
        }

        public Long getAssigneeType() {
            return this.assigneeType;
        }

        public Long getAvatarId() {
            return this.avatarId;
        }

        @ExperimentalApi
        public boolean isKeyChanged() {
            return this.keyChanged;
        }

        @ExperimentalApi
        @Nullable
        public ApplicationUser getUser() {
            return this.user;
        }
    }

    @PublicApi
    public static class UpdateProjectSchemesValidationResult
    extends ServiceResultImpl {
        private Long permissionSchemeId;
        private Long notificationSchemeId;
        private Long issueSecuritySchemeId;

        @Internal
        public UpdateProjectSchemesValidationResult(ErrorCollection errorCollection) {
            super(errorCollection);
        }

        @Internal
        public UpdateProjectSchemesValidationResult(ErrorCollection errorCollection, Long permissionSchemeId, Long notificationSchemeId, Long issueSecuritySchemeId) {
            super(errorCollection);
            this.permissionSchemeId = permissionSchemeId;
            this.notificationSchemeId = notificationSchemeId;
            this.issueSecuritySchemeId = issueSecuritySchemeId;
        }

        public Long getPermissionSchemeId() {
            return this.permissionSchemeId;
        }

        public Long getNotificationSchemeId() {
            return this.notificationSchemeId;
        }

        public Long getIssueSecuritySchemeId() {
            return this.issueSecuritySchemeId;
        }
    }
}

