/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class LocalDateIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = Logger.getLogger(LocalDateIndexer.class);

    public LocalDateIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    @Override
    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    @Override
    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Date) {
            Timestamp date = (Timestamp)value;
            if (((Date)date).getTime() > 0L) {
                LocalDate localDate = LocalDateFactory.from(date);
                doc.add((Fieldable)new Field(this.getDocumentFieldId(), LuceneUtils.localDateToString(localDate), Field.Store.YES, indexType));
            } else {
                log.warn((Object)("Unable to index custom date field '" + this.customField.getName() + "(" + this.customField.getId() + ") with value: " + value));
            }
        }
    }
}

