/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import java.util.HashMap;
import java.util.Map;
import webwork.action.Action;

public class CustomFieldRenderer
implements SearchRenderer {
    private final ClauseNames clauseNames;
    private final CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor;
    private final CustomField field;
    private final CustomFieldValueProvider customFieldValueProvider;
    private final FieldVisibilityManager fieldVisibilityManager;

    public CustomFieldRenderer(ClauseNames clauseNames, CustomFieldSearcherModuleDescriptor customFieldSearcherModuleDescriptor, CustomField field, CustomFieldValueProvider customFieldValueProvider, FieldVisibilityManager fieldVisibilityManager) {
        this.clauseNames = clauseNames;
        this.customFieldSearcherModuleDescriptor = customFieldSearcherModuleDescriptor;
        this.field = field;
        this.customFieldValueProvider = customFieldValueProvider;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    @Override
    public boolean isRelevantForQuery(User searcher, Query query) {
        return this.isExistsInQuery(query);
    }

    @Override
    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        return this.getEditHtml(searchContext, fieldValuesHolder, displayParameters, action, new HashMap<String, Object>());
    }

    @Override
    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        return this.getViewHtml(searchContext, fieldValuesHolder, displayParameters, action, new HashMap<String, Object>());
    }

    public CustomField getField() {
        return this.field;
    }

    @Override
    public boolean isShown(User searcher, SearchContext searchContext) {
        return CustomFieldUtils.isShownAndVisible(this.getField(), searcher, searchContext, this.fieldVisibilityManager);
    }

    public String getEditHtml(SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action, Map<String, Object> velocityParams) {
        return this.getDescriptor().getSearchHtml(this.getField(), this.customFieldValueProvider, searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    public String getViewHtml(SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action, Map<String, Object> velocityParams) {
        return this.getDescriptor().getViewHtml(this.getField(), this.customFieldValueProvider, searchContext, fieldValuesHolder, displayParameters, action, velocityParams);
    }

    CustomFieldSearcherModuleDescriptor getDescriptor() {
        return this.customFieldSearcherModuleDescriptor;
    }

    boolean isExistsInQuery(Query query) {
        NamedTerminalClauseCollectingVisitor clauseVisitor = new NamedTerminalClauseCollectingVisitor(this.clauseNames.getJqlFieldNames());
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept(clauseVisitor);
        }
        return clauseVisitor.containsNamedClause();
    }
}

