/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationRecipient;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

@PublicApi
public class MentionIssueEvent {
    private final Issue issue;
    private final User fromUser;
    private final Set<User> toUsers;
    private final String mentionText;
    private final String fieldId;
    private final Set<NotificationRecipient> currentRecipients;

    public MentionIssueEvent(Issue issue, User fromUser, Set<User> toUsers, String mentionText, String fieldId, Set<NotificationRecipient> currentRecipients) {
        this.issue = issue;
        this.fromUser = fromUser;
        this.toUsers = toUsers;
        this.mentionText = mentionText;
        this.fieldId = fieldId;
        this.currentRecipients = currentRecipients;
    }

    public Issue getIssue() {
        return this.issue;
    }

    public User getFromUser() {
        return this.fromUser;
    }

    public Set<User> getToUsers() {
        return Collections.unmodifiableSet(this.toUsers);
    }

    public String getMentionText() {
        return this.mentionText;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public Set<NotificationRecipient> getCurrentRecipients() {
        return this.currentRecipients;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MentionIssueEvent that = (MentionIssueEvent)o;
        if (!((Object)this.currentRecipients).equals(that.currentRecipients)) {
            return false;
        }
        if (!this.fieldId.equals(that.fieldId)) {
            return false;
        }
        if (!this.fromUser.equals(that.fromUser)) {
            return false;
        }
        if (this.issue != null ? !this.issue.equals(that.issue) : that.issue != null) {
            return false;
        }
        if (this.mentionText != null ? !this.mentionText.equals(that.mentionText) : that.mentionText != null) {
            return false;
        }
        return ((Object)this.toUsers).equals(that.toUsers);
    }

    public int hashCode() {
        int result = this.issue != null ? this.issue.hashCode() : 0;
        result = 31 * result + this.fromUser.hashCode();
        result = 31 * result + ((Object)this.toUsers).hashCode();
        result = 31 * result + (this.mentionText != null ? this.mentionText.hashCode() : 0);
        result = 31 * result + this.fieldId.hashCode();
        result = 31 * result + ((Object)this.currentRecipients).hashCode();
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("issue", (Object)this.issue).append("fromUser", (Object)this.fromUser).append("toUsers", this.toUsers).append("mentionText", (Object)this.mentionText).append("fieldId", (Object)this.fieldId).append("currentRecipients", this.currentRecipients).toString();
    }
}

