/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import com.atlassian.integrationtesting.ui.UiTester;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.io.IOUtils;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class UiRunListener
extends RunListener {
    private final File outputDirectory;
    private final UiTester uiTester;

    @Inject
    public UiRunListener(UiTester uiTester, @OutputDirectory File outputDirectory) {
        this.uiTester = uiTester;
        this.outputDirectory = outputDirectory;
    }

    public void testFailure(Failure failure) throws Exception {
        super.testFailure(failure);
        this.outputHtmlToFile(failure.getDescription().getDisplayName() + ".html", failure.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputHtmlToFile(String filename, String failureMessage) throws IOException {
        this.outputDirectory.mkdirs();
        File file = new File(this.outputDirectory, filename);
        OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(file));
        try {
            out.write(failureMessage != null ? failureMessage : "Failure");
            out.write(this.uiTester.getHtmlContents());
            System.err.println("Html captured to file: " + file.getAbsolutePath());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.PARAMETER, ElementType.FIELD})
    public static @interface OutputDirectory {
    }
}

