/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.Functions;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.RestoreFromBackupException;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.integrationtesting.ui.UiTesterFunctionProvider;
import com.atlassian.integrationtesting.ui.UiTesters;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Jira implements UiTesterFunctionProvider
{
    v4_1{
        private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("login.jsp").submitButtonId("login").build();
        private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormName("loginform");

        @Override
        public Function<CompositeUiTester.Login, HtmlPage> logIn() {
            return this.logIn;
        }

        @Override
        public Function<UiTester, Boolean> isOnLogInPage() {
            return this.isOnLogInPage;
        }

        @Override
        public Function<CompositeUiTester.Backup, Void> restore() {
            return Jira.restoreData((Function<UiTesters.BackupFile, Void>)Jira.quickImport());
        }
    }
    ,
    v4_2{
        private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormId("login-form");

        @Override
        public Function<UiTester, Boolean> isOnLogInPage() {
            return this.isOnLogInPage;
        }

        @Override
        public Function<CompositeUiTester.Backup, Void> restore() {
            return Jira.restoreData((Function<UiTesters.BackupFile, Void>)Jira.quickImport());
        }
    }
    ,
    v4_3{
        private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormId("login-form");

        @Override
        public Function<UiTester, Boolean> isOnLogInPage() {
            return this.isOnLogInPage;
        }

        @Override
        public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
            return JiraWebSudoLogin.INSTANCE;
        }

        @Override
        public Function<CompositeUiTester.Backup, Void> restore() {
            return Jira.restoreData((Function<UiTesters.BackupFile, Void>)Jira.regularImport());
        }
    };

    private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("login.jsp").submitButtonId("login-form-submit").build();
    private final Function<UiTester, Void> logout = new Function<UiTester, Void>(){
        final Function<UiTester, Void> goToLogOutPage = UiTesters.goToPageToLogout("secure/Logout!default.jspa");

        public Void apply(UiTester uiTester) {
            return UiTesters.withJavascriptDisabled(uiTester, Functions.partiallyApply(this.goToLogOutPage, uiTester));
        }
    };

    @Override
    public Function<CompositeUiTester.Login, HtmlPage> logIn() {
        return this.logIn;
    }

    @Override
    public Function<UiTester, Void> logout() {
        return this.logout;
    }

    @Override
    public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
        return UiTesters.doNothingWebSudoLogin();
    }

    @Override
    public Function<UiTester, String> getLoggedInUser() {
        return UiTesters.getLoggedInUser();
    }

    private static Function<CompositeUiTester.Backup, Void> restoreData(final Function<UiTesters.BackupFile, Void> restore) {
        return new Function<CompositeUiTester.Backup, Void>(){
            final Function<CompositeUiTester.Backup, Void> res;
            {
                this.res = UiTesters.restore(ProcessBackupData.INSTANCE, (Function<UiTesters.BackupFile, Void>)restore);
            }

            public Void apply(CompositeUiTester.Backup backup) {
                return UiTesters.withJavascriptDisabled(backup.client, Functions.partiallyApply(this.res, backup));
            }
        };
    }

    private static Function<UiTesters.BackupFile, Void> quickImport() {
        return Restore.QUICK;
    }

    private static Function<UiTesters.BackupFile, Void> regularImport() {
        return Restore.REGULAR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum JiraWebSudoLogin implements Function<CompositeUiTester.WebSudoLogin, HtmlPage>
    {
        INSTANCE;


        public HtmlPage apply(CompositeUiTester.WebSudoLogin login) {
            login.client.gotoPage("secure/admin/XmlRestore!default.jspa");
            Doj form = login.client.currentPage().get("form").first();
            if (form != null && form.attribute("action").endsWith("WebSudoAuthenticate.jspa")) {
                form.getById("login-form-authenticatePassword").value(login.password);
                try {
                    return (HtmlPage)form.get("input").withId("authenticateButton").click();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return (HtmlPage)login.client.currentPage().firstElement().getPage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Restore implements Function<UiTesters.BackupFile, Void>
    {
        QUICK(true),
        REGULAR(false);

        private final boolean quickImport;

        private Restore(boolean quickImport) {
            this.quickImport = quickImport;
        }

        public Void apply(UiTesters.BackupFile backup) {
            try {
                HtmlPage page;
                Doj doj;
                Doj errorArea;
                backup.client.gotoPage("secure/admin/XmlRestore!default.jspa");
                backup.client.currentPage().getByAttribute("name", "filename").value(backup.file.getAbsolutePath());
                if (this.quickImport) {
                    backup.client.currentPage().getById("quickImport").check();
                }
                if (!(errorArea = (doj = Doj.on((HtmlPage)(page = (HtmlPage)backup.client.currentPage().getById("restore_submit").click()))).get("div.errorArea")).isEmpty()) {
                    String error = errorArea.get("ul li").text();
                    if (error.contains("You must edit jira-application.properties") && error.contains("jira.paths.set.allowed=true")) {
                        throw new RestoreFromBackupException("Unable to restore because JIRA does not allow restoring unless the jira.paths.set.allowed property in the jira-application.properties file is set to true.  If you are using AMPS,you can customize the jira-application.properties file by creating an\"overlay\" in your src/test/resources directory.  Create the directory src/test/resources/{instance-id}-app/WEB-INF/classes - where {instance-id} isreplaced with the applications instance ID, typically just the applicationname when running a single application in the test group - and place yourcustomized jira-applications.properties file in that directory.");
                    }
                    throw new RestoreFromBackupException(error);
                }
            }
            catch (IOException e) {
                throw new RestoreFromBackupException(e);
            }
            catch (ClassCastException e) {
                throw new RestoreFromBackupException("Element with id 'restore_submit' is not a button");
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProcessBackupData implements Function<CompositeUiTester.Backup, File>
    {
        INSTANCE;


        public File apply(CompositeUiTester.Backup backup) {
            try {
                String data = FileUtils.readFileToString((File)FileUtils.toFile((URL)backup.data));
                data = data.replaceAll("@jira-home@", UiTesters.getHome());
                data = data.replaceAll("@base-url@", backup.client.getBaseUrl());
                File dataFile = new File(UiTesters.getHome(), "import/backup" + RandomStringUtils.randomAlphanumeric((int)5) + ".xml");
                FileUtils.writeStringToFile((File)dataFile, (String)data);
                return dataFile;
            }
            catch (IOException e) {
                throw new RestoreFromBackupException("Unable to process backup data file " + backup.data, e);
            }
        }
    }
}

