/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.RestoreFromBackupException;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.integrationtesting.ui.UiTesterFunctionProvider;
import com.atlassian.integrationtesting.ui.UiTesters;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.RandomStringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Confluence implements UiTesterFunctionProvider
{
    v3_1,
    v3_2,
    v3_3{

        @Override
        public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
            return ConfluenceWebSudoLogin.INSTANCE;
        }
    }
    ,
    v3_4{

        @Override
        public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
            return ConfluenceWebSudoLogin.INSTANCE;
        }
    }
    ,
    v3_5{

        @Override
        public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
            return ConfluenceWebSudoLogin.INSTANCE;
        }
    };

    private final Function<UiTester, Void> logout = UiTesters.goToPageToLogout("logout.action");
    private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("login.action").formName("loginform").submitButtonId("loginButton").build();
    private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormName("loginform");

    @Override
    public Function<UiTester, Void> logout() {
        return this.logout;
    }

    @Override
    public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
        return UiTesters.doNothingWebSudoLogin();
    }

    @Override
    public Function<CompositeUiTester.Login, HtmlPage> logIn() {
        return this.logIn;
    }

    @Override
    public Function<UiTester, Boolean> isOnLogInPage() {
        return this.isOnLogInPage;
    }

    @Override
    public Function<UiTester, String> getLoggedInUser() {
        return UiTesters.getLoggedInUser();
    }

    @Override
    public Function<CompositeUiTester.Backup, Void> restore() {
        return UiTesters.restore(ProcessBackupData.INSTANCE, Restore.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProcessBackupData implements Function<CompositeUiTester.Backup, File>
    {
        INSTANCE;

        private static final String ENTITIES_XML = "entities.xml";

        public File apply(CompositeUiTester.Backup backup) {
            File dataFile = new File(UiTesters.getHome(), "restore/backup" + RandomStringUtils.randomAlphanumeric((int)5) + ".zip");
            InputStream in = null;
            ZipInputStream zin = null;
            FileOutputStream out = null;
            ZipOutputStream zout = null;
            try {
                FileUtils.forceMkdir((File)dataFile.getParentFile());
                dataFile.createNewFile();
                in = backup.data.openStream();
                zin = new ZipInputStream(in);
                out = new FileOutputStream(dataFile);
                zout = new ZipOutputStream(out);
                ZipEntry inEntry = null;
                while ((inEntry = zin.getNextEntry()) != null) {
                    if (inEntry.getName().equals(ENTITIES_XML)) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)zin, (OutputStream)baos);
                        String data = baos.toString().replaceAll("@base-url@", backup.client.getBaseUrl());
                        zout.putNextEntry(new ZipEntry(ENTITIES_XML));
                        IOUtils.copy((Reader)new StringReader(data), (OutputStream)zout);
                        zout.closeEntry();
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(inEntry.getName()));
                    IOUtils.copy((InputStream)zin, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
            catch (IOException e) {
                try {
                    throw new RestoreFromBackupException("Unable to process backup data file " + backup.data, e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zin);
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(zout);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)zin);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)zout);
            IOUtils.closeQuietly((OutputStream)out);
            return dataFile;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Restore implements Function<UiTesters.BackupFile, Void>
    {
        INSTANCE;


        public Void apply(UiTesters.BackupFile backup) {
            try {
                backup.client.gotoPage("admin/backup.action");
                backup.client.currentPage().getByTag("option").withValue(backup.file.getName()).select();
                HtmlPage page = (HtmlPage)backup.client.currentPage().get("input").withType("submit").withValue("Restore").click();
                Preconditions.checkState((boolean)Doj.on((HtmlPage)page).get("#title-text").text().contains("Importing Data - In Progress"));
                boolean complete = false;
                boolean failed = false;
                while (!complete && !failed) {
                    String importStatus = Doj.on((HtmlPage)page).get("#taskCurrentStatus").text();
                    if ("Complete.".equals(importStatus)) {
                        complete = true;
                        continue;
                    }
                    if (importStatus.startsWith("Import failed")) {
                        failed = true;
                        continue;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {}
                }
                if (failed) {
                    throw new RestoreFromBackupException("Failed to restore data. Check the Confluence logs for more information.");
                }
            }
            catch (ClassCastException e) {
                throw new RestoreFromBackupException("Element with id 'restore_submit' is not a button");
            }
            catch (IOException e) {
                throw new RestoreFromBackupException(e);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConfluenceWebSudoLogin implements Function<CompositeUiTester.WebSudoLogin, HtmlPage>
    {
        INSTANCE;


        public HtmlPage apply(CompositeUiTester.WebSudoLogin login) {
            login.client.gotoPage("admin/viewgeneralconfig.action");
            Doj form = login.client.currentPage().get("form").first();
            if (form != null && form.attribute("action").endsWith("doauthenticate.action")) {
                form.get("#password").value(login.password);
                try {
                    return (HtmlPage)form.get("input").withId("authenticateButton").click();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return (HtmlPage)login.client.currentPage().firstElement().getPage();
        }
    }
}

