/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.ui;

import be.roam.hue.doj.Doj;
import com.atlassian.integrationtesting.ui.CompositeUiTester;
import com.atlassian.integrationtesting.ui.RestoreFromBackupException;
import com.atlassian.integrationtesting.ui.UiTester;
import com.atlassian.integrationtesting.ui.UiTesterFunctionProvider;
import com.atlassian.integrationtesting.ui.UiTesters;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Bamboo implements UiTesterFunctionProvider
{
    v2_5,
    v2_6,
    v3_0;

    private final Function<CompositeUiTester.Login, HtmlPage> logIn = UiTesters.logInByGoingTo("userlogin!default.action").formId("loginForm").build();
    private final Function<UiTester, Boolean> isOnLogInPage = UiTesters.isOnLogInPageByFormId("loginForm");

    @Override
    public Function<CompositeUiTester.Login, HtmlPage> logIn() {
        return this.logIn;
    }

    @Override
    public Function<CompositeUiTester.WebSudoLogin, HtmlPage> webSudoLogIn() {
        return UiTesters.doNothingWebSudoLogin();
    }

    @Override
    public Function<UiTester, Boolean> isOnLogInPage() {
        return this.isOnLogInPage;
    }

    @Override
    public Function<UiTester, Void> logout() {
        return UiTesters.goToPageToLogout("userLogout.action");
    }

    @Override
    public Function<UiTester, String> getLoggedInUser() {
        return UiTesters.getLoggedInUser();
    }

    @Override
    public Function<CompositeUiTester.Backup, Void> restore() {
        return UiTesters.restore(ProcessBackupData.INSTANCE, Restore.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ProcessBackupData implements Function<CompositeUiTester.Backup, File>
    {
        INSTANCE;

        private static final String ADMIN_CONFIG = "configuration/administration.xml";

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public File apply(CompositeUiTester.Backup backup) {
            File dataFile = new File(UiTesters.getHome(), "import/backup" + RandomStringUtils.randomAlphanumeric((int)5) + ".zip");
            InputStream in = null;
            ZipInputStream zin = null;
            FileOutputStream out = null;
            ZipOutputStream zout = null;
            try {
                FileUtils.forceMkdir((File)dataFile.getParentFile());
                dataFile.createNewFile();
                in = backup.data.openStream();
                zin = new ZipInputStream(in);
                out = new FileOutputStream(dataFile);
                zout = new ZipOutputStream(out);
                ZipEntry inEntry = null;
                while ((inEntry = zin.getNextEntry()) != null) {
                    if (inEntry.getName().equals(ADMIN_CONFIG)) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)zin, (OutputStream)baos);
                        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                        Document doc = this.parse(bais);
                        this.updateBaseUrl(doc, backup.client.getBaseUrl());
                        zout.putNextEntry(new ZipEntry(ADMIN_CONFIG));
                        this.write(doc, zout);
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(inEntry.getName()));
                    IOUtils.copy((InputStream)zin, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
            catch (IOException e) {
                try {
                    throw new RestoreFromBackupException("Unable to process backup data file " + backup.data, e);
                    catch (ParserConfigurationException e2) {
                        throw new RestoreFromBackupException("Unable to process backup data file " + backup.data, e2);
                    }
                    catch (SAXException e3) {
                        throw new RestoreFromBackupException("Unable to process backup data file " + backup.data, e3);
                    }
                    catch (TransformerFactoryConfigurationError e4) {
                        throw new RestoreFromBackupException("Unable to process backup data file " + backup.data, e4);
                    }
                    catch (TransformerException e5) {
                        throw new RestoreFromBackupException("Unable to process backup data file " + backup.data, e5);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zin);
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(zout);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)zin);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)zout);
            IOUtils.closeQuietly((OutputStream)out);
            return dataFile;
        }

        private void write(Document doc, OutputStream out) throws TransformerFactoryConfigurationError, TransformerException {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(out);
            DOMSource source = new DOMSource(doc);
            transformer.transform(source, result);
        }

        private void updateBaseUrl(Document doc, String baseUrl) {
            this.updateElementWithText(doc, "myBaseUrl", baseUrl);
        }

        private void updateElementWithText(Document doc, String elementName, String value) {
            NodeList nodes = doc.getElementsByTagName(elementName);
            if (nodes.getLength() != 0) {
                nodes.item(0).getParentNode().removeChild(nodes.item(0));
            }
            Element element = doc.createElement(elementName);
            element.appendChild(doc.createTextNode(value));
            doc.getDocumentElement().appendChild(element);
        }

        private Document parse(ByteArrayInputStream bais) throws ParserConfigurationException, SAXException, IOException {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(bais);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Restore implements Function<UiTesters.BackupFile, Void>
    {
        INSTANCE;


        public Void apply(UiTesters.BackupFile backup) {
            try {
                backup.client.gotoPage("admin/import!default.action");
                backup.client.currentPage().getById("importForm_path").value(backup.file.getAbsolutePath());
                backup.client.currentPage().getById("importForm_backupSelected").uncheck();
                backup.client.currentPage().getById("importForm_hotSwapSelected").check();
                HtmlPage page = (HtmlPage)backup.client.currentPage().get(".formFooter input").attribute("type", "submit").click();
                Doj.on((HtmlPage)page).get(".formFooter input").attribute("type", "submit").click();
            }
            catch (ClassCastException e) {
                throw new RestoreFromBackupException("Element with id 'restore_submit' is not a button");
            }
            catch (IOException e) {
                throw new RestoreFromBackupException(e);
            }
            return null;
        }
    }
}

