/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.runner.restore;

import com.atlassian.integrationtesting.runner.CompositeTestRunner;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.integrationtesting.ui.UiTester;
import com.google.common.base.Function;
import com.google.inject.Injector;

public final class RestoreFromBackup {
    public static CompositeTestRunner.Composer compose(Injector injector) {
        return CompositeTestRunner.compose().beforeTestClass(new BeforeClass(injector)).beforeTestMethod(new BeforeMethod(injector)).afterTestMethod(new AfterMethod(injector));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AfterMethod
    implements Function<CompositeTestRunner.AfterTestMethod, Void> {
        private final Injector injector;

        public AfterMethod(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.AfterTestMethod test) {
            if (test.hasAnnotation(Restore.class) && test.hasAnnotation(RestoreOnce.class)) {
                ((UiTester)this.injector.getInstance(UiTester.class)).restore(test.getAnnotation(RestoreOnce.class).value());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BeforeMethod
    implements Function<CompositeTestRunner.BeforeTestMethod, Void> {
        private final Injector injector;

        public BeforeMethod(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.BeforeTestMethod test) {
            if (test.hasAnnotation(Restore.class)) {
                Restore restore = test.getAnnotation(Restore.class);
                ((UiTester)this.injector.getInstance(UiTester.class)).restore(restore.value(), restore.user());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BeforeClass
    implements Function<CompositeTestRunner.BeforeTestClass, Void> {
        private final Injector injector;

        public BeforeClass(Injector injector) {
            this.injector = injector;
        }

        public Void apply(CompositeTestRunner.BeforeTestClass test) {
            if (test.hasAnnotation(RestoreOnce.class)) {
                if (test.hasAnnotation(Restore.class)) {
                    throw new RuntimeException("Both @Restore and @RestoreOnce found on class. Only one should be present.");
                }
                RestoreOnce restoreOnce = test.getAnnotation(RestoreOnce.class);
                ((UiTester)this.injector.getInstance(UiTester.class)).restore(restoreOnce.value(), restoreOnce.user());
            }
            return null;
        }
    }
}

