/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.integrationtesting.runner;

import com.atlassian.integrationtesting.runner.CompositeTestRunner;
import com.atlassian.integrationtesting.runner.TestGroups;
import com.google.common.base.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestGroupRunner
extends CompositeTestRunner {
    public TestGroupRunner(Class<?> klass) throws InitializationError {
        super(klass, TestGroupRunner.compose());
    }

    public static CompositeTestRunner.Composer compose() {
        return CompositeTestRunner.compose().shouldRunTestsInClass(TestGroupRunner.shouldRunTestsInClass()).shouldRunTestMethod(TestGroupRunner.shouldRunTestMethod());
    }

    private static Predicate<TestClass> shouldRunTestsInClass() {
        return ShouldRunTestsInClass.INSTANCE;
    }

    private static Predicate<FrameworkMethod> shouldRunTestMethod() {
        return ShouldRunTestMethod.INSTANCE;
    }

    private static boolean shouldRun(TestGroups testGroups) {
        if (testGroups == null) {
            return true;
        }
        String runningTestGroup = TestGroupRunner.getRunningTestGroup();
        return TestGroupRunner.includesTestGroup(testGroups, runningTestGroup) && !TestGroupRunner.excludesTestGroup(testGroups, runningTestGroup);
    }

    private static boolean excludesTestGroup(TestGroups testGroups, String runningTestGroup) {
        return ArrayUtils.contains((Object[])testGroups.excludes(), (Object)runningTestGroup);
    }

    private static boolean includesTestGroup(TestGroups testGroups, String runningTestGroup) {
        return testGroups.value().length == 1 && "*".equals(testGroups.value()[0]) || ArrayUtils.contains((Object[])testGroups.value(), (Object)runningTestGroup);
    }

    public static String getRunningTestGroup() {
        return System.getProperty("testGroup");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ShouldRunTestMethod implements Predicate<FrameworkMethod>
    {
        INSTANCE;


        public boolean apply(FrameworkMethod method) {
            return TestGroupRunner.shouldRun((TestGroups)method.getAnnotation(TestGroups.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ShouldRunTestsInClass implements Predicate<TestClass>
    {
        INSTANCE;


        public boolean apply(TestClass testClass) {
            return TestGroupRunner.shouldRun(testClass.getJavaClass().getAnnotation(TestGroups.class));
        }
    }
}

