package com.atlassian.integrationtesting.ui;

import java.io.IOException;

import com.atlassian.integrationtesting.ui.CompositeUiTester.Backup;
import com.atlassian.integrationtesting.ui.CompositeUiTester.Login;
import com.atlassian.integrationtesting.ui.CompositeUiTester.WebSudoLogin;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.google.common.base.Function;

import be.roam.hue.doj.Doj;

import static com.atlassian.integrationtesting.ui.UiTesters.doNothingWebSudoLogin;
import static com.atlassian.integrationtesting.ui.UiTesters.logInByGoingTo;
import static com.atlassian.integrationtesting.ui.UiTesters.restoreUnsupported;
import static com.google.common.base.Preconditions.checkState;
import static org.apache.commons.lang.StringUtils.isBlank;

/**
 * {@code UiTesterProvider}s for RefApp versions 2.6 and 2.7.
 */
public enum RefApp implements UiTesterFunctionProvider
{
    v2_6
    {
        public Function<WebSudoLogin, HtmlPage> webSudoLogIn()
        {
            return doNothingWebSudoLogin();
        }
    },
    v2_7;
    
    private final Function<Login, HtmlPage> logIn = logInByGoingTo("plugins/servlet/login").submitButtonName("login").build();
    public Function<Login, HtmlPage> logIn()
    {
        return logIn;
    }

    public Function<WebSudoLogin, HtmlPage> webSudoLogIn()
    {
        return RefappWebSudoLogin.INSTANCE;
    }

    public Function<UiTester, Void> logout()
    {
        return Logout.INSTANCE;
    }

    public Function<UiTester, Boolean> isOnLogInPage()
    {
        return IsOnLogInPage.INSTANCE;
    }

    public Function<UiTester, String> getLoggedInUser()
    {
        return UiTesters.getLoggedInUser();
    }

    private enum RefappWebSudoLogin implements Function<WebSudoLogin, HtmlPage>
    {
        INSTANCE;

        public HtmlPage apply(WebSudoLogin login)
        {
            // Lets kick in the webSudo
            login.client.gotoPage("/plugins/servlet/websudo");

             final Doj form = login.client.currentPage().get("form").first();
             // We are on the web sudo login page
             if (form != null && form.attribute("action").endsWith("/plugins/servlet/websudo"))
             {
                 form.get("#os_password").value(login.password);
                 try
                 {
                     return (HtmlPage) form.get("button").withId("websudo").click();
                 }
                 catch (IOException e)
                 {
                     throw new RuntimeException(e);
                 }
             }

             return (HtmlPage) login.client.currentPage().firstElement().getPage();
        }
    }

    private enum Logout implements Function<UiTester, Void>
    {
        INSTANCE;

        public Void apply(UiTester uiTester)
        {
            final HtmlPage loginPage = uiTester.gotoPage("plugins/servlet/login");
            Doj form = Doj.on(loginPage).get("form").first();
            Doj logoutButton = form.get("button").withId("logout");

            checkState(logoutButton != null, "Unable to find logout button");

            try
            {
                logoutButton.click();
            }
            catch (IOException ioe)
            {
                throw new RuntimeException(ioe);
            }
            return null;
        }
    }
    
    private enum IsOnLogInPage implements Function<UiTester, Boolean>
    {
        INSTANCE;

        public Boolean apply(UiTester uiTester)
        {
            String action = uiTester.currentPage().get("form").attribute("action");
            return !isBlank(action) && (action.endsWith("login") || action.endsWith("logout"));
        }
    }
    
    public Function<Backup, Void> restore()
    {
        return restoreUnsupported("Refapp does not support online data restores.");
    }
}
