package com.atlassian.integrationtesting.runner;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to specify which test groups the test should be run under.  If this annotation is missing or no parameters
 * are specified, the test will be run in all test groups.  If the annotation specifies a list of test groups, the test
 * will only be run in those test groups.  If a list of {@code excludes} are provided, the test will be run in all test
 * groups except those specified.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE})
public @interface TestGroups
{
    String[] value() default { "*" };
    
    String[] excludes() default { };
    
    String reason() default "";
}
