/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fugue;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Function2;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.MapMaker;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Functions {
    private Functions() {
    }

    public static <F, T> T fold(Function2<T, F, T> f, T zero, Iterable<F> elements) {
        T currentValue = zero;
        for (F element : elements) {
            currentValue = f.apply(currentValue, element);
        }
        return currentValue;
    }

    public static <F, T> T fold(final Function<Pair<T, F>, T> f, T zero, Iterable<F> elements) {
        return Functions.fold(new Function2<T, F, T>(){

            @Override
            public T apply(T arg1, F arg2) {
                return f.apply(new Pair(arg1, arg2));
            }
        }, zero, elements);
    }

    static <T> Function<Supplier<? extends T>, T> fromSupplier() {
        return new ValueExtractor();
    }

    public static <A, B> Function<Function<A, B>, B> apply(final A arg) {
        return new Function<Function<A, B>, B>(){

            public B apply(Function<A, B> f) {
                return f.apply(arg);
            }
        };
    }

    static <T> Function<Supplier<? extends T>, Supplier<T>> ignoreExceptions() {
        return new ExceptionIgnorer();
    }

    static <T> Function<T, List<T>> singletonList(Class<T> c) {
        return new SingletonList();
    }

    static <F, T> Function<F, T> memoize(final Function<F, T> delegate, final MapMaker mapMaker) {
        return new Function<F, T>(){
            final Map<F, T> map;
            {
                this.map = mapMaker.makeComputingMap(delegate);
            }

            public T apply(F from) {
                return this.map.get(from);
            }
        };
    }

    static Function<String, Either<NumberFormatException, Long>> parseLong() {
        return ParseLong.INSTANCE;
    }

    static <A> Function<A, Iterator<A>> singletonIterator() {
        return new Function<A, Iterator<A>>(){

            public Iterator<A> apply(A a) {
                return Iterators.singletonIterator(a);
            }
        };
    }

    static <A, X> Function<X, Iterator<A>> emptyIterator() {
        return new Function<X, Iterator<A>>(){

            public Iterator<A> apply(X a) {
                return ImmutableList.of().iterator();
            }
        };
    }

    static Function<Object, String> toStringFunction() {
        return com.google.common.base.Functions.toStringFunction();
    }

    static <A> Effect<A> toEffect(final Function<A, ?> function) {
        return new Effect<A>(){

            @Override
            public void apply(A a) {
                function.apply(a);
            }
        };
    }

    static Function<String, Either<NumberFormatException, Integer>> parseInt() {
        return ParseInt.INSTANCE;
    }

    static Function<String, Option<String>> trimToNone() {
        return TrimToNone.INSTANCE;
    }

    static <T> Function<T, T> identity() {
        return com.google.common.base.Functions.identity();
    }

    static <A> Function<A, Option<A>> option() {
        return new ToOption();
    }

    static <A, B> Function<A, B> constant(final B constant) {
        return new Function<A, B>(){

            public B apply(A from) {
                return constant;
            }
        };
    }

    private static class ToOption<A>
    implements Function<A, Option<A>> {
        private ToOption() {
        }

        public Option<A> apply(A from) {
            return Option.option(from);
        }
    }

    private static enum TrimToNone implements Function<String, Option<String>>
    {
        INSTANCE;


        public Option<String> apply(String s) {
            if (s == null) {
                return Option.none();
            }
            String trimmed = s.trim();
            return trimmed.isEmpty() ? Option.none() : Option.some(trimmed);
        }
    }

    private static enum ParseInt implements Function<String, Either<NumberFormatException, Integer>>
    {
        INSTANCE;


        public Either<NumberFormatException, Integer> apply(String s) {
            try {
                return Either.right(Integer.valueOf(s));
            }
            catch (NumberFormatException e) {
                return Either.left(e);
            }
        }
    }

    private static enum ParseLong implements Function<String, Either<NumberFormatException, Long>>
    {
        INSTANCE;


        public Either<NumberFormatException, Long> apply(String s) {
            try {
                return Either.right(Long.valueOf(s));
            }
            catch (NumberFormatException e) {
                return Either.left(e);
            }
        }
    }

    static final class Memoizer<F, T>
    implements Function<F, T> {
        final Map<F, T> map;

        Memoizer(Function<F, T> delegate, MapMaker mapMaker) {
            this.map = mapMaker.makeComputingMap(delegate);
        }

        public T apply(F from) {
            return this.map.get(from);
        }
    }

    private static final class SingletonList<T>
    implements Function<T, List<T>> {
        private SingletonList() {
        }

        public List<T> apply(T o) {
            return ImmutableList.of(o);
        }
    }

    static class IgnoreAndReturnNull<T>
    implements Supplier<T> {
        private final Supplier<? extends T> delegate;

        IgnoreAndReturnNull(Supplier<? extends T> delegate) {
            this.delegate = (Supplier)Preconditions.checkNotNull(delegate);
        }

        public T get() {
            try {
                return (T)this.delegate.get();
            }
            catch (RuntimeException ignore) {
                return null;
            }
        }
    }

    static class ExceptionIgnorer<T>
    implements Function<Supplier<? extends T>, Supplier<T>> {
        ExceptionIgnorer() {
        }

        public Supplier<T> apply(Supplier<? extends T> from) {
            return new IgnoreAndReturnNull<T>(from);
        }
    }

    private static class ValueExtractor<T>
    implements Function<Supplier<? extends T>, T> {
        private ValueExtractor() {
        }

        public T apply(Supplier<? extends T> supplier) {
            return (T)supplier.get();
        }
    }
}

