/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.EntityByteArrayInputStream;
import com.atlassian.httpclient.api.Message;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.util.CharArrayBuffer;

abstract class DefaultMessage
implements Message {
    private String contentType;
    private String contentCharset;
    private InputStream entityStream;
    private boolean hasRead;
    private Map<String, String> headers;
    private boolean isFrozen;
    private final long maxEntitySize;

    public DefaultMessage() {
        this(Integer.MAX_VALUE);
    }

    public DefaultMessage(long maxEntitySize) {
        this.maxEntitySize = maxEntitySize;
        this.headers = Maps.newHashMap();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Message setContentType(String contentType) {
        this.checkMutable();
        this.parseContentType(contentType);
        return this;
    }

    public String getContentCharset() {
        return this.contentCharset;
    }

    public Message setContentCharset(String contentCharset) {
        this.checkMutable();
        this.contentCharset = contentCharset != null ? Charset.forName(contentCharset).name() : null;
        return this;
    }

    public InputStream getEntityStream() throws IllegalStateException {
        this.checkRead();
        this.checkValidSize();
        return this.entityStream;
    }

    public Message setEntityStream(InputStream entityStream) {
        this.checkMutable();
        this.entityStream = entityStream;
        this.hasRead = false;
        return this;
    }

    public Message setEntityStream(InputStream entityStream, String charset) {
        this.checkMutable();
        this.setEntityStream(entityStream);
        this.setContentCharset(charset);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEntity() throws IllegalStateException, IllegalArgumentException {
        String entity = null;
        if (this.hasEntity()) {
            String string;
            String charsetAsString = this.getContentCharset();
            Charset charset = charsetAsString != null ? Charset.forName(charsetAsString) : Charset.forName("UTF-8");
            InputStream instream = this.getEntityStream();
            if (instream == null) {
                return null;
            }
            try {
                int l;
                int bufferLength = 4096;
                String lengthHeader = this.getHeader("Content-Length");
                if (lengthHeader != null) {
                    bufferLength = Integer.parseInt(lengthHeader);
                }
                InputStreamReader reader = new InputStreamReader(instream, charset);
                CharArrayBuffer buffer = new CharArrayBuffer(bufferLength);
                char[] tmp = new char[1024];
                while ((l = reader.read(tmp)) != -1) {
                    if ((long)(buffer.length() + l) > this.maxEntitySize) {
                        throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
                    }
                    buffer.append(tmp, 0, l);
                }
                string = buffer.toString();
            }
            catch (Throwable throwable) {
                try {
                    instream.close();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to convert response body to String", e);
                }
            }
            instream.close();
            return string;
        }
        return entity;
    }

    public Message setEntity(String entity) {
        this.checkMutable();
        if (entity != null) {
            String charset = "UTF-8";
            byte[] bytes = entity.getBytes(Charset.forName("UTF-8"));
            this.setEntityStream(new EntityByteArrayInputStream(bytes), "UTF-8");
        } else {
            this.setEntityStream(null, null);
        }
        return this;
    }

    public boolean hasEntity() {
        return this.entityStream != null;
    }

    HttpEntity getHttpEntity() {
        InputStreamEntity entity = null;
        if (this.hasEntity()) {
            if (this.entityStream instanceof ByteArrayInputStream) {
                byte[] bytes;
                if (this.entityStream instanceof EntityByteArrayInputStream) {
                    bytes = ((EntityByteArrayInputStream)this.entityStream).getBytes();
                } else {
                    try {
                        bytes = ByteStreams.toByteArray((InputStream)this.entityStream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                entity = new ByteArrayEntity(bytes);
            } else {
                entity = new InputStreamEntity(this.entityStream, -1L);
            }
        }
        return entity;
    }

    public boolean hasReadEntity() {
        return this.hasRead;
    }

    public Map<String, String> getHeaders() {
        HashMap headers = Maps.newHashMap(this.headers);
        if (this.contentType != null) {
            headers.put("Content-Type", this.buildContentType());
        }
        return Collections.unmodifiableMap(headers);
    }

    public Message setHeaders(Map<String, String> headers) {
        this.checkMutable();
        this.headers.clear();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.setHeader(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public String getHeader(String name) {
        String value = name.equalsIgnoreCase("Content-Type") ? this.buildContentType() : this.headers.get(name);
        return value;
    }

    public Message setHeader(String name, String value) {
        this.checkMutable();
        if (name.equalsIgnoreCase("Content-Type")) {
            this.parseContentType(value);
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    public Message validate() {
        if (this.hasEntity() && this.contentType == null) {
            throw new IllegalStateException("Property contentType must be set when entity is present");
        }
        return this;
    }

    private void checkRead() throws IllegalStateException {
        if (this.entityStream != null) {
            if (this.hasRead) {
                throw new IllegalStateException("Entity may only be accessed once");
            }
            this.hasRead = true;
        }
    }

    private void checkValidSize() throws IllegalArgumentException {
        Integer contentLength;
        String lengthHeader = this.getHeader("Content-Length");
        if (lengthHeader != null && (long)(contentLength = Integer.valueOf(Integer.parseInt(lengthHeader))).intValue() > this.maxEntitySize) {
            throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
        }
    }

    private String buildContentType() {
        String value;
        String string = value = this.contentType != null ? this.contentType : "text/plain";
        if (this.contentCharset != null) {
            value = value + "; charset=" + this.contentCharset;
        }
        return value;
    }

    private void parseContentType(String value) {
        if (value != null) {
            String[] parts = value.split(";");
            if (parts.length >= 1) {
                this.contentType = parts[0].trim();
            }
            if (parts.length >= 2) {
                String subtype = parts[1].trim();
                if (subtype.startsWith("charset=")) {
                    this.setContentCharset(subtype.substring(8));
                } else if (subtype.startsWith("boundary=")) {
                    this.contentType = this.contentType.concat(';' + subtype);
                }
            }
        } else {
            this.contentType = null;
        }
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    protected Message freeze() {
        this.isFrozen = true;
        return this;
    }

    protected void checkMutable() {
        Preconditions.checkState((!this.isFrozen ? 1 : 0) != 0, (Object)"Object cannot be changed once frozen");
    }
}

