/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultRequest;
import com.atlassian.httpclient.apache.httpcomponents.DefaultResponse;
import com.atlassian.httpclient.apache.httpcomponents.FlushableHttpCacheStorage;
import com.atlassian.httpclient.apache.httpcomponents.MavenUtils;
import com.atlassian.httpclient.apache.httpcomponents.PromiseHttpAsyncClient;
import com.atlassian.httpclient.apache.httpcomponents.ProxySelectorAsyncRoutePlanner;
import com.atlassian.httpclient.apache.httpcomponents.SettableFuturePromiseHttpPromiseAsyncClient;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponsePromise;
import com.atlassian.httpclient.api.ResponsePromises;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.httpclient.base.AbstractHttpClient;
import com.atlassian.httpclient.base.event.HttpRequestCompletedEvent;
import com.atlassian.httpclient.base.event.HttpRequestFailedEvent;
import com.atlassian.httpclient.spi.ThreadLocalContextManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpAsyncClient;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.impl.nio.conn.AsyncSchemeRegistryFactory;
import org.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.ClientAsyncConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorExceptionHandler;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public final class DefaultHttpClient<C>
extends AbstractHttpClient
implements HttpClient,
DisposableBean {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final ThreadLocalContextManager<C> threadLocalContextManager;
    private final ExecutorService callbackExecutor;
    private final HttpClientOptions httpClientOptions;
    private final HttpAsyncClient httpClient;
    private final HttpAsyncClient nonCachingHttpClient;
    private final FlushableHttpCacheStorage httpCacheStorage;

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager) {
        this(eventPublisher, applicationProperties, threadLocalContextManager, new HttpClientOptions());
    }

    public DefaultHttpClient(EventPublisher eventPublisher, ApplicationProperties applicationProperties, ThreadLocalContextManager<C> threadLocalContextManager, HttpClientOptions options) {
        DefaultHttpAsyncClient client;
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.threadLocalContextManager = (ThreadLocalContextManager)Preconditions.checkNotNull(threadLocalContextManager);
        this.httpClientOptions = (HttpClientOptions)Preconditions.checkNotNull((Object)options);
        try {
            IOReactorConfig ioReactorConfig = new IOReactorConfig();
            ioReactorConfig.setIoThreadCount(options.getIoThreadCount());
            ioReactorConfig.setSelectInterval(options.getIoSelectInterval());
            ioReactorConfig.setInterestOpQueued(true);
            DefaultConnectingIOReactor reactor = new DefaultConnectingIOReactor(ioReactorConfig, ThreadFactories.namedThreadFactory((String)(options.getThreadPrefix() + "-io"), (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
            reactor.setExceptionHandler(new IOReactorExceptionHandler(){

                public boolean handle(IOException ex) {
                    DefaultHttpClient.this.log.error("IO exception in reactor", (Throwable)ex);
                    return false;
                }

                public boolean handle(RuntimeException ex) {
                    DefaultHttpClient.this.log.error("Fatal runtime error", (Throwable)ex);
                    return false;
                }
            });
            PoolingClientAsyncConnectionManager connmgr = new PoolingClientAsyncConnectionManager((ConnectingIOReactor)reactor, AsyncSchemeRegistryFactory.createDefault(), options.getConnectionPoolTimeToLive(), options.getLeaseTimeout(), TimeUnit.MILLISECONDS){

                protected void finalize() throws Throwable {
                }
            };
            connmgr.setDefaultMaxPerRoute(options.getMaxConnectionsPerHost());
            client = new DefaultHttpAsyncClient((ClientAsyncConnectionManager)connmgr);
            client.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){
                final String[] REDIRECT_METHODS = new String[]{"HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"};

                protected boolean isRedirectable(String method) {
                    for (String m : this.REDIRECT_METHODS) {
                        if (!m.equalsIgnoreCase(method)) continue;
                        return true;
                    }
                    return false;
                }

                public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                    URI uri = this.getLocationURI(request, response, context);
                    String method = request.getRequestLine().getMethod();
                    if (method.equalsIgnoreCase("HEAD")) {
                        return new HttpHead(uri);
                    }
                    if (method.equalsIgnoreCase("GET")) {
                        return new HttpGet(uri);
                    }
                    if (method.equalsIgnoreCase("POST")) {
                        HttpPost post = new HttpPost(uri);
                        if (request instanceof HttpEntityEnclosingRequest) {
                            post.setEntity(((HttpEntityEnclosingRequest)request).getEntity());
                        }
                        return post;
                    }
                    if (method.equalsIgnoreCase("PUT")) {
                        return new HttpPut(uri);
                    }
                    if (method.equalsIgnoreCase("DELETE")) {
                        return new HttpDelete(uri);
                    }
                    if (method.equalsIgnoreCase("PATCH")) {
                        return new HttpPatch(uri);
                    }
                    return new HttpGet(uri);
                }
            });
        }
        catch (IOReactorException e) {
            throw new RuntimeException("Reactor " + options.getThreadPrefix() + "not set up correctly", e);
        }
        HttpParams params = client.getParams();
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)this.getUserAgent(options));
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)((int)options.getConnectionTimeout()));
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)((int)options.getSocketTimeout()));
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        ProxySelectorAsyncRoutePlanner routePlanner = new ProxySelectorAsyncRoutePlanner(client.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        client.setRoutePlanner((HttpRoutePlanner)routePlanner);
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setMaxCacheEntries(options.getMaxCacheEntries());
        cacheConfig.setSharedCache(false);
        cacheConfig.setMaxObjectSize(options.getMaxCacheObjectSize());
        cacheConfig.setNeverCache1_0ResponsesWithQueryString(false);
        this.nonCachingHttpClient = client;
        this.httpCacheStorage = new FlushableHttpCacheStorage(cacheConfig);
        this.httpClient = new CachingHttpAsyncClient((HttpAsyncClient)client, (HttpCacheStorage)this.httpCacheStorage, cacheConfig);
        this.callbackExecutor = this.httpClientOptions.getCallbackExecutor();
        this.httpClient.start();
    }

    private String getUserAgent(HttpClientOptions options) {
        return String.format("Atlassian HttpClient %s / %s-%s (%s) / %s", MavenUtils.getVersion("com.atlassian.httpclient", "atlassian-httpclient-api"), this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber(), options.getUserAgent());
    }

    @Override
    public final ResponsePromise execute(DefaultRequest request) {
        try {
            return this.doExecute(request);
        }
        catch (Throwable t) {
            return ResponsePromises.toResponsePromise((Promise)Promises.rejected((Throwable)t, Response.class));
        }
    }

    private ResponsePromise doExecute(final DefaultRequest request) {
        HttpGet op;
        this.httpClientOptions.getRequestPreparer().apply((Object)request);
        request.validate();
        request.freeze();
        final long start = System.currentTimeMillis();
        String uri = request.getUri().toString();
        Request.Method method = request.getMethod();
        switch (method) {
            case GET: {
                op = new HttpGet(uri);
                break;
            }
            case POST: {
                op = new HttpPost(uri);
                break;
            }
            case PUT: {
                op = new HttpPut(uri);
                break;
            }
            case DELETE: {
                op = new HttpDelete(uri);
                break;
            }
            case OPTIONS: {
                op = new HttpOptions(uri);
                break;
            }
            case HEAD: {
                op = new HttpHead(uri);
                break;
            }
            case TRACE: {
                op = new HttpTrace(uri);
                break;
            }
            default: {
                throw new UnsupportedOperationException(method.toString());
            }
        }
        if (request.hasEntity()) {
            if (op instanceof HttpEntityEnclosingRequestBase) {
                ((HttpEntityEnclosingRequestBase)op).setEntity(request.getHttpEntity());
            } else {
                throw new UnsupportedOperationException("HTTP method " + method + " does not support sending an entity");
            }
        }
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            op.setHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return ResponsePromises.toResponsePromise((Promise)this.getPromiseHttpAsyncClient(request).execute((HttpUriRequest)op, (HttpContext)new BasicHttpContext()).fold((Function)new Function<Throwable, Response>(){

            public Response apply(Throwable ex) {
                long requestDuration = System.currentTimeMillis() - start;
                DefaultHttpClient.this.publishEvent(request, requestDuration, ex);
                throw Throwables.propagate((Throwable)ex);
            }
        }, (Function)new Function<HttpResponse, Response>(){

            public Response apply(HttpResponse httpResponse) {
                long requestDuration = System.currentTimeMillis() - start;
                DefaultHttpClient.this.publishEvent(request, requestDuration, httpResponse.getStatusLine().getStatusCode());
                try {
                    return DefaultHttpClient.this.translate(httpResponse).freeze();
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }));
    }

    private void publishEvent(Request request, long requestDuration, int statusCode) {
        if (HttpStatus.OK.code <= statusCode && statusCode < HttpStatus.MULTIPLE_CHOICES.code) {
            this.eventPublisher.publish((Object)new HttpRequestCompletedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, (Map<String, String>)request.getAttributes()));
        } else {
            this.eventPublisher.publish((Object)new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), statusCode, requestDuration, (Map<String, String>)request.getAttributes()));
        }
    }

    private void publishEvent(Request request, long requestDuration, Throwable ex) {
        this.eventPublisher.publish((Object)new HttpRequestFailedEvent(request.getUri().toString(), request.getMethod().name(), ex.toString(), requestDuration, (Map<String, String>)request.getAttributes()));
    }

    private PromiseHttpAsyncClient getPromiseHttpAsyncClient(DefaultRequest request) {
        return new SettableFuturePromiseHttpPromiseAsyncClient<C>(request.isCacheDisabled() ? this.nonCachingHttpClient : this.httpClient, this.threadLocalContextManager, this.callbackExecutor);
    }

    private DefaultResponse translate(HttpResponse httpResponse) throws IOException {
        Header[] httpHeaders;
        StatusLine status = httpResponse.getStatusLine();
        DefaultResponse response = new DefaultResponse(this.httpClientOptions.getMaxEntitySize());
        response.setStatusCode(status.getStatusCode());
        response.setStatusText(status.getReasonPhrase());
        for (Header httpHeader : httpHeaders = httpResponse.getAllHeaders()) {
            response.setHeader(httpHeader.getName(), httpHeader.getValue());
        }
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            response.setEntityStream(entity.getContent());
        }
        return response;
    }

    public void destroy() throws Exception {
        this.callbackExecutor.shutdown();
        this.httpClient.shutdown();
    }

    public void flushCacheByUriPattern(Pattern urlPattern) {
        this.httpCacheStorage.flushByUriPattern(urlPattern);
    }
}

