/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.git.tripper;

import com.atlassian.git.tripper.GitLogFormatPlaceholder;
import com.atlassian.git.tripper.GitLogFormatString;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Immutable
public final class ImmutableGitLogFormatString
extends GitLogFormatString {
    private final ImmutableList<GitLogFormatPlaceholder> placeholders;
    private final String delimiter;

    private ImmutableGitLogFormatString(ImmutableList<GitLogFormatPlaceholder> placeholders, String delimiter) {
        this.placeholders = placeholders;
        this.delimiter = delimiter;
    }

    public ImmutableList<GitLogFormatPlaceholder> getPlaceholders() {
        return this.placeholders;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    public final ImmutableGitLogFormatString withPlaceholders(GitLogFormatPlaceholder ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableGitLogFormatString((ImmutableList<GitLogFormatPlaceholder>)newValue, this.delimiter);
    }

    public final ImmutableGitLogFormatString withPlaceholders(Iterable<? extends GitLogFormatPlaceholder> elements) {
        if (this.placeholders == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableGitLogFormatString((ImmutableList<GitLogFormatPlaceholder>)newValue, this.delimiter);
    }

    public final ImmutableGitLogFormatString withDelimiter(String value) {
        if (this.delimiter.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "delimiter");
        return new ImmutableGitLogFormatString(this.placeholders, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGitLogFormatString && this.equalTo((ImmutableGitLogFormatString)another);
    }

    private boolean equalTo(ImmutableGitLogFormatString another) {
        return this.placeholders.equals(another.placeholders) && this.delimiter.equals(another.delimiter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.placeholders.hashCode();
        h += (h << 5) + this.delimiter.hashCode();
        return h;
    }

    public static ImmutableGitLogFormatString copyOf(GitLogFormatString instance) {
        if (instance instanceof ImmutableGitLogFormatString) {
            return (ImmutableGitLogFormatString)instance;
        }
        return ImmutableGitLogFormatString.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DELIMITER = 1L;
        private long initBits = 1L;
        private ImmutableList.Builder<GitLogFormatPlaceholder> placeholders = ImmutableList.builder();
        @Nullable
        private String delimiter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GitLogFormatString instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllPlaceholders(instance.getPlaceholders());
            this.delimiter(instance.getDelimiter());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPlaceholders(GitLogFormatPlaceholder element) {
            this.placeholders.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPlaceholders(GitLogFormatPlaceholder ... elements) {
            this.placeholders.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder placeholders(Iterable<? extends GitLogFormatPlaceholder> elements) {
            this.placeholders = ImmutableList.builder();
            return this.addAllPlaceholders(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPlaceholders(Iterable<? extends GitLogFormatPlaceholder> elements) {
            this.placeholders.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder delimiter(String delimiter) {
            this.delimiter = Objects.requireNonNull(delimiter, "delimiter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGitLogFormatString build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGitLogFormatString(this.placeholders.build(), this.delimiter);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList attributes = Lists.newArrayList();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("delimiter");
            }
            return "Cannot build GitLogFormatString, some of required attributes are not set " + attributes;
        }
    }
}

