package com.atlassian.extras.decoder.api;

import java.util.Properties;


public interface LicenseDecoder {

    /**
     * {@link #decode} may throw a {@link LicenseVerificationException} if we manage to decode the properties but fail
     * to verify the license signature. The failure may be because of several reasons and the exception provides
     * error codes for programatic use (see {@link LicenseVerificationException.VerificationFailureReason}).
     * In this case the decoded properties can be retieved from the exception using
     * {@link LicenseVerificationException#getLicenseProperties()}.
     **/
    Properties decode(final String licenseString) throws LicenseVerificationException;

    boolean canDecode(String licenseString);
}
