package com.atlassian.diagnostics;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IssueBuilder {

    /**
     * Builds the issue
     *
     * @return the issue
     */
    @Nonnull
    Issue build();

    /**
     * @param value the i18n key for the issue's description
     * @return the builder
     */
    @Nonnull
    IssueBuilder descriptionI18nKey(@Nonnull String value);

    /**
     * Sets a custom helper class to convert {@link Alert#getDetails() alert details} to and from JSON for alerts
     * of this issue. This only needs to be set if the alert details cannot be processed by the default Jackson
     * {@code ObjectMapper}. When set to {@code null}, the default Jackson {@code ObjectMapper} is used.
     *
     * @param value the i18n key for the issue's description
     * @return the builder
     */
    @Nonnull
    IssueBuilder jsonMapper(@Nullable JsonMapper value);

    /**
     * @param value the issue's severity
     * @return the builder
     */
    @Nonnull
    IssueBuilder severity(@Nonnull Severity value);

    /**
     * @param value the i18n key for the issue's summary
     * @return the builder
     */
    @Nonnull
    IssueBuilder summaryI18nKey(@Nonnull String value);
}
