package com.atlassian.diagnostics.ipd.internal.spi;

import com.atlassian.annotations.ExperimentalApi;

/**
 * In product Diagnostic Job which will be run by {@link IpdJobRunner}.
 * Objects of this interface have to be registered in Job Runner.
 * <pre>
 * {@code
 *     public CustomIpdJob(final IpdJobRunner jobRunner) {
 *         jobRunner.register(this);
 *     }
 * }
 * </pre>
 *
 * @since 2.2.0
 */
@ExperimentalApi
public interface IpdJob {

    /**
     * This method is executed periodically on an IPD scheduler. You implement it to make IPD measurements on a regular basis.
     */
    void runJob();

    /**
     * Indicates that the job is controlled by the WIP feature flag
     * @see IpdFeatureFlagAware
     */
    default boolean isWorkInProgressJob() {
        return false;
    }
}
