package com.atlassian.diagnostics.ipd.internal.spi;

import com.atlassian.util.profiling.MetricKey;

import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * MetricOptions contains parameters for ipd metric creation.
 *
 * @since 3.0.0
 */
public class MetricOptions {
    private final String productPrefix;
    private final Supplier<Boolean> enabledCheck;
    private final Consumer<IpdMetric> metricUpdateListener;

    private final MetricKey ipdMetricKey;
    private final boolean regularLogging;

    public MetricOptions(final MetricKey ipdMetricKey,
                         final String productPrefix,
                         final Supplier<Boolean> enabledCheck,
                         final Consumer<IpdMetric> metricUpdateListener,
                         final boolean regularLogging) {
        this.productPrefix = productPrefix;
        this.enabledCheck = enabledCheck;
        this.metricUpdateListener = metricUpdateListener;
        this.ipdMetricKey = ipdMetricKey;
        this.regularLogging = regularLogging;
    }

    public String getProductPrefix() {
        return productPrefix;
    }

    public Supplier<Boolean> getEnabledCheck() {
        return enabledCheck;
    }

    public Consumer<IpdMetric> getMetricUpdateListener() {
        return metricUpdateListener;
    }

    public MetricKey getIpdMetricKey() {
        return ipdMetricKey;
    }

    public boolean isRegularLogging() {
        return regularLogging;
    }
}
