/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devrel.servlet;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@LicensedOnly
public abstract class RequiresLoginServlet
extends HttpServlet {
    private final UserManager userManager;
    private final TemplateRenderer renderer;
    private final LoginUriProvider loginUriProvider;

    public RequiresLoginServlet(UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider) {
        this.userManager = Objects.requireNonNull(userManager, "userManager");
        this.renderer = Objects.requireNonNull(renderer, "renderer");
        this.loginUriProvider = Objects.requireNonNull(loginUriProvider, "loginUriProvider");
    }

    public abstract String getTemplatePath();

    public abstract Map<String, Object> getContext(HttpServletRequest var1);

    protected final void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String username = this.userManager.getRemoteUsername(req);
        if (username == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        resp.setContentType("text/html;charset=utf-8");
        this.renderer.render(this.getTemplatePath(), this.getContext(req), (Writer)resp.getWriter());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

