/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devrel.servlet;

import com.atlassian.devrel.checks.PluginChecks;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ToolbarServlet
extends HttpServlet {
    private static final String QR_PLUGIN_KEY = "com.atlassian.labs.plugins.quickreload.reloader";
    private static final String TOOLBAR_TEMPLATE = "/templates/toolbar.vm";
    private TemplateRenderer renderer;
    private ApplicationProperties applicationProperties;
    private DynamicWebInterfaceManager webInterfaceManager;
    private PluginChecks checks;

    public ToolbarServlet(TemplateRenderer renderer, ApplicationProperties applicationProperties, DynamicWebInterfaceManager webInterfaceManager, PluginChecks checks) {
        this.webInterfaceManager = webInterfaceManager;
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.checks = checks;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap context = Maps.newHashMap();
        HashMap condition = Maps.newHashMap();
        context.put("navBarItems", this.webInterfaceManager.getDisplayableWebItems("dev-toolbar", (Map)condition));
        context.put("navBarMenuItems", this.webInterfaceManager.getDisplayableWebItems("dev-toolbar-menu", (Map)condition));
        context.put("app", this.applicationProperties);
        context.put("sdkVersion", System.getProperty("atlassian.sdk.version", "3.7 or earlier"));
        context.put("devToolboxVersion", this.checks.getDevtoolboxVersion());
        context.put("quickreloadVersion", this.checks.getQuickReloadVersion());
        resp.setContentType("text/html;charset=utf-8");
        this.renderer.render(TOOLBAR_TEMPLATE, (Map)context, (Writer)resp.getWriter());
    }

    private String getAppName() {
        return this.applicationProperties.getDisplayName().toLowerCase();
    }
}

