/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas.pullrequest;

import com.atlassian.devops.schemas.UserReference;
import com.atlassian.devops.schemas.jackson.InstantToIso861Deserializer;
import com.atlassian.devops.schemas.jackson.InstantToIso861Serializer;
import com.atlassian.devops.schemas.pullrequest.BranchReference;
import com.atlassian.devops.schemas.pullrequest.PullRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PullRequest", generator="Immutables")
@Immutable
public final class ImmutablePullRequest
implements PullRequest {
    private final String id;
    private final String title;
    private final URL url;
    private final PullRequest.State state;
    private final Instant updatedDate;
    private final int commentCount;
    private final BranchReference sourceBranch;
    private final BranchReference destinationBranch;
    @Nullable
    private final Instant createdDate;
    @Nullable
    private final UserReference author;

    private ImmutablePullRequest(String id, String title, URL url, PullRequest.State state, Instant updatedDate, int commentCount, BranchReference sourceBranch, BranchReference destinationBranch, @Nullable Instant createdDate, @Nullable UserReference author) {
        this.id = id;
        this.title = title;
        this.url = url;
        this.state = state;
        this.updatedDate = updatedDate;
        this.commentCount = commentCount;
        this.sourceBranch = sourceBranch;
        this.destinationBranch = destinationBranch;
        this.createdDate = createdDate;
        this.author = author;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String title() {
        return this.title;
    }

    @Override
    @JsonProperty
    public URL url() {
        return this.url;
    }

    @Override
    @JsonProperty
    public PullRequest.State state() {
        return this.state;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=InstantToIso861Serializer.class)
    @JsonDeserialize(using=InstantToIso861Deserializer.class)
    public Instant updatedDate() {
        return this.updatedDate;
    }

    @Override
    @JsonProperty
    public int commentCount() {
        return this.commentCount;
    }

    @Override
    @JsonProperty
    public BranchReference sourceBranch() {
        return this.sourceBranch;
    }

    @Override
    @JsonProperty
    public BranchReference destinationBranch() {
        return this.destinationBranch;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=InstantToIso861Serializer.class)
    @JsonDeserialize(using=InstantToIso861Deserializer.class)
    @Nullable
    public Instant createdDate() {
        return this.createdDate;
    }

    @Override
    @JsonProperty
    @Nullable
    public UserReference author() {
        return this.author;
    }

    public final ImmutablePullRequest withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePullRequest(newValue, this.title, this.url, this.state, this.updatedDate, this.commentCount, this.sourceBranch, this.destinationBranch, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutablePullRequest(this.id, newValue, this.url, this.state, this.updatedDate, this.commentCount, this.sourceBranch, this.destinationBranch, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withUrl(URL value) {
        if (this.url == value) {
            return this;
        }
        URL newValue = Objects.requireNonNull(value, "url");
        return new ImmutablePullRequest(this.id, this.title, newValue, this.state, this.updatedDate, this.commentCount, this.sourceBranch, this.destinationBranch, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withState(PullRequest.State value) {
        if (this.state == value) {
            return this;
        }
        PullRequest.State newValue = Objects.requireNonNull(value, "state");
        if (this.state.equals((Object)newValue)) {
            return this;
        }
        return new ImmutablePullRequest(this.id, this.title, this.url, newValue, this.updatedDate, this.commentCount, this.sourceBranch, this.destinationBranch, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withUpdatedDate(Instant value) {
        if (this.updatedDate == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "updatedDate");
        return new ImmutablePullRequest(this.id, this.title, this.url, this.state, newValue, this.commentCount, this.sourceBranch, this.destinationBranch, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withCommentCount(int value) {
        if (this.commentCount == value) {
            return this;
        }
        return new ImmutablePullRequest(this.id, this.title, this.url, this.state, this.updatedDate, value, this.sourceBranch, this.destinationBranch, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withSourceBranch(BranchReference value) {
        if (this.sourceBranch == value) {
            return this;
        }
        BranchReference newValue = Objects.requireNonNull(value, "sourceBranch");
        return new ImmutablePullRequest(this.id, this.title, this.url, this.state, this.updatedDate, this.commentCount, newValue, this.destinationBranch, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withDestinationBranch(BranchReference value) {
        if (this.destinationBranch == value) {
            return this;
        }
        BranchReference newValue = Objects.requireNonNull(value, "destinationBranch");
        return new ImmutablePullRequest(this.id, this.title, this.url, this.state, this.updatedDate, this.commentCount, this.sourceBranch, newValue, this.createdDate, this.author);
    }

    public final ImmutablePullRequest withCreatedDate(@Nullable Instant value) {
        if (this.createdDate == value) {
            return this;
        }
        return new ImmutablePullRequest(this.id, this.title, this.url, this.state, this.updatedDate, this.commentCount, this.sourceBranch, this.destinationBranch, value, this.author);
    }

    public final ImmutablePullRequest withAuthor(@Nullable UserReference value) {
        if (this.author == value) {
            return this;
        }
        return new ImmutablePullRequest(this.id, this.title, this.url, this.state, this.updatedDate, this.commentCount, this.sourceBranch, this.destinationBranch, this.createdDate, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePullRequest && this.equalTo((ImmutablePullRequest)another);
    }

    private boolean equalTo(ImmutablePullRequest another) {
        return this.id.equals(another.id) && this.title.equals(another.title) && this.url.equals(another.url) && this.state.equals((Object)another.state) && this.updatedDate.equals(another.updatedDate) && this.commentCount == another.commentCount && this.sourceBranch.equals(another.sourceBranch) && this.destinationBranch.equals(another.destinationBranch) && Objects.equals(this.createdDate, another.createdDate) && Objects.equals(this.author, another.author);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.state.hashCode();
        h += (h << 5) + this.updatedDate.hashCode();
        h += (h << 5) + this.commentCount;
        h += (h << 5) + this.sourceBranch.hashCode();
        h += (h << 5) + this.destinationBranch.hashCode();
        h += (h << 5) + Objects.hashCode(this.createdDate);
        h += (h << 5) + Objects.hashCode(this.author);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PullRequest").omitNullValues().add("id", (Object)this.id).add("title", (Object)this.title).add("url", (Object)this.url).add("state", (Object)this.state).add("updatedDate", (Object)this.updatedDate).add("commentCount", this.commentCount).add("sourceBranch", (Object)this.sourceBranch).add("destinationBranch", (Object)this.destinationBranch).add("createdDate", (Object)this.createdDate).add("author", (Object)this.author).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePullRequest fromJson(Json json) {
        Builder builder = (Builder)ImmutablePullRequest.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.title != null) {
            builder.title(json.title);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        if (json.updatedDate != null) {
            builder.updatedDate(json.updatedDate);
        }
        if (json.commentCountIsSet) {
            builder.commentCount(json.commentCount);
        }
        if (json.sourceBranch != null) {
            builder.sourceBranch(json.sourceBranch);
        }
        if (json.destinationBranch != null) {
            builder.destinationBranch(json.destinationBranch);
        }
        if (json.createdDateIsSet) {
            builder.createdDate(json.createdDate);
        }
        if (json.authorIsSet) {
            builder.author(json.author);
        }
        return builder.build();
    }

    public static ImmutablePullRequest copyOf(PullRequest instance) {
        if (instance instanceof ImmutablePullRequest) {
            return (ImmutablePullRequest)instance;
        }
        return ((Builder)ImmutablePullRequest.builder()).id(instance.id()).title(instance.title()).url(instance.url()).state(instance.state()).updatedDate(instance.updatedDate()).commentCount(instance.commentCount()).sourceBranch(instance.sourceBranch()).destinationBranch(instance.destinationBranch()).createdDate(instance.createdDate()).author(instance.author()).build();
    }

    public static IdBuildStage builder() {
        return new Builder();
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface BuildFinal {
        public BuildFinal createdDate(@Nullable Instant var1);

        public BuildFinal author(@Nullable UserReference var1);

        public ImmutablePullRequest build();
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface DestinationBranchBuildStage {
        public BuildFinal destinationBranch(BranchReference var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface SourceBranchBuildStage {
        public DestinationBranchBuildStage sourceBranch(BranchReference var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface CommentCountBuildStage {
        public SourceBranchBuildStage commentCount(int var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface UpdatedDateBuildStage {
        public CommentCountBuildStage updatedDate(Instant var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface StateBuildStage {
        public UpdatedDateBuildStage state(PullRequest.State var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface UrlBuildStage {
        public StateBuildStage url(URL var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface TitleBuildStage {
        public UrlBuildStage title(String var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    public static interface IdBuildStage {
        public TitleBuildStage id(String var1);
    }

    @Generated(from="PullRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements IdBuildStage,
    TitleBuildStage,
    UrlBuildStage,
    StateBuildStage,
    UpdatedDateBuildStage,
    CommentCountBuildStage,
    SourceBranchBuildStage,
    DestinationBranchBuildStage,
    BuildFinal {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long INIT_BIT_URL = 4L;
        private static final long INIT_BIT_STATE = 8L;
        private static final long INIT_BIT_UPDATED_DATE = 16L;
        private static final long INIT_BIT_COMMENT_COUNT = 32L;
        private static final long INIT_BIT_SOURCE_BRANCH = 64L;
        private static final long INIT_BIT_DESTINATION_BRANCH = 128L;
        private static final long OPT_BIT_CREATED_DATE = 1L;
        private static final long OPT_BIT_AUTHOR = 2L;
        private long initBits = 255L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String title;
        @Nullable
        private URL url;
        @Nullable
        private PullRequest.State state;
        @Nullable
        private Instant updatedDate;
        private int commentCount;
        @Nullable
        private BranchReference sourceBranch;
        @Nullable
        private BranchReference destinationBranch;
        @Nullable
        private Instant createdDate;
        @Nullable
        private UserReference author;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder title(String title) {
            Builder.checkNotIsSet(this.titleIsSet(), "title");
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(URL url) {
            Builder.checkNotIsSet(this.urlIsSet(), "url");
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder state(PullRequest.State state) {
            Builder.checkNotIsSet(this.stateIsSet(), "state");
            this.state = Objects.requireNonNull(state, "state");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @Override
        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        @CanIgnoreReturnValue
        public final Builder updatedDate(Instant updatedDate) {
            Builder.checkNotIsSet(this.updatedDateIsSet(), "updatedDate");
            this.updatedDate = Objects.requireNonNull(updatedDate, "updatedDate");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder commentCount(int commentCount) {
            Builder.checkNotIsSet(this.commentCountIsSet(), "commentCount");
            this.commentCount = commentCount;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder sourceBranch(BranchReference sourceBranch) {
            Builder.checkNotIsSet(this.sourceBranchIsSet(), "sourceBranch");
            this.sourceBranch = Objects.requireNonNull(sourceBranch, "sourceBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder destinationBranch(BranchReference destinationBranch) {
            Builder.checkNotIsSet(this.destinationBranchIsSet(), "destinationBranch");
            this.destinationBranch = Objects.requireNonNull(destinationBranch, "destinationBranch");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @Override
        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        @CanIgnoreReturnValue
        public final Builder createdDate(@Nullable Instant createdDate) {
            Builder.checkNotIsSet(this.createdDateIsSet(), "createdDate");
            this.createdDate = createdDate;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder author(@Nullable UserReference author) {
            Builder.checkNotIsSet(this.authorIsSet(), "author");
            this.author = author;
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutablePullRequest build() {
            this.checkRequiredAttributes();
            return new ImmutablePullRequest(this.id, this.title, this.url, this.state, this.updatedDate, this.commentCount, this.sourceBranch, this.destinationBranch, this.createdDate, this.author);
        }

        private boolean createdDateIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean authorIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean urlIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean stateIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean updatedDateIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean commentCountIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean sourceBranchIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean destinationBranchIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of PullRequest is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            if (!this.stateIsSet()) {
                attributes.add("state");
            }
            if (!this.updatedDateIsSet()) {
                attributes.add("updatedDate");
            }
            if (!this.commentCountIsSet()) {
                attributes.add("commentCount");
            }
            if (!this.sourceBranchIsSet()) {
                attributes.add("sourceBranch");
            }
            if (!this.destinationBranchIsSet()) {
                attributes.add("destinationBranch");
            }
            return "Cannot build PullRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PullRequest", generator="Immutables")
    static final class Json
    implements PullRequest {
        @Nullable
        String id;
        @Nullable
        String title;
        @Nullable
        URL url;
        @Nullable
        PullRequest.State state;
        @Nullable
        Instant updatedDate;
        int commentCount;
        boolean commentCountIsSet;
        @Nullable
        BranchReference sourceBranch;
        @Nullable
        BranchReference destinationBranch;
        @Nullable
        Instant createdDate;
        boolean createdDateIsSet;
        @Nullable
        UserReference author;
        boolean authorIsSet;

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setUrl(URL url) {
            this.url = url;
        }

        @JsonProperty
        public void setState(PullRequest.State state) {
            this.state = state;
        }

        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        public void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        @JsonProperty
        public void setCommentCount(int commentCount) {
            this.commentCount = commentCount;
            this.commentCountIsSet = true;
        }

        @JsonProperty
        public void setSourceBranch(BranchReference sourceBranch) {
            this.sourceBranch = sourceBranch;
        }

        @JsonProperty
        public void setDestinationBranch(BranchReference destinationBranch) {
            this.destinationBranch = destinationBranch;
        }

        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        public void setCreatedDate(@Nullable Instant createdDate) {
            this.createdDate = createdDate;
            this.createdDateIsSet = true;
        }

        @JsonProperty
        public void setAuthor(@Nullable UserReference author) {
            this.author = author;
            this.authorIsSet = true;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String title() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URL url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public PullRequest.State state() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant updatedDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int commentCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BranchReference sourceBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BranchReference destinationBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant createdDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UserReference author() {
            throw new UnsupportedOperationException();
        }
    }
}

