/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas.jackson;

import com.atlassian.devops.schemas.Association;
import com.atlassian.devops.schemas.BasicAssociationType;
import com.atlassian.devops.schemas.ImmutableBasicAssociation;
import com.atlassian.devops.schemas.ImmutableIssueAssociation;
import com.atlassian.devops.schemas.IssueAssociationType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

public class AssociationDeserializer
extends JsonDeserializer<Association> {
    public Association deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAs(JsonNode.class);
        JsonNode type = jsonNode.findValue("type");
        if (type != null) {
            String typeAsText = type.asText("default-not-mapped");
            if (BasicAssociationType.fromJson(typeAsText) != null) {
                return (Association)jsonParser.getCodec().treeToValue((TreeNode)jsonNode, ImmutableBasicAssociation.class);
            }
            if (IssueAssociationType.fromJson(typeAsText) != null) {
                return (Association)jsonParser.getCodec().treeToValue((TreeNode)jsonNode, ImmutableIssueAssociation.class);
            }
            throw new IOException("Cannot deserialize association for type: " + typeAsText);
        }
        throw new IOException("No type available for association");
    }
}

