/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas.commit;

import com.atlassian.devops.schemas.UserReference;
import com.atlassian.devops.schemas.commit.Commit;
import com.atlassian.devops.schemas.jackson.InstantToIso861Deserializer;
import com.atlassian.devops.schemas.jackson.InstantToIso861Serializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Commit", generator="Immutables")
@Immutable
public final class ImmutableCommit
implements Commit {
    @Nullable
    private final UserReference author;
    private final String hash;
    @Nullable
    private final URL url;
    private final Instant timestamp;
    private final Set<Commit.Flag> flags;
    private final String message;

    private ImmutableCommit(@Nullable UserReference author, String hash, @Nullable URL url, Instant timestamp, Set<Commit.Flag> flags, String message) {
        this.author = author;
        this.hash = hash;
        this.url = url;
        this.timestamp = timestamp;
        this.flags = flags;
        this.message = message;
    }

    @Override
    @JsonProperty
    @Nullable
    public UserReference author() {
        return this.author;
    }

    @Override
    @JsonProperty(value="hash")
    public String hash() {
        return this.hash;
    }

    @Override
    @JsonProperty
    @Nullable
    public URL url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @JsonSerialize(using=InstantToIso861Serializer.class)
    @JsonDeserialize(using=InstantToIso861Deserializer.class)
    public Instant timestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty
    public Set<Commit.Flag> flags() {
        return this.flags;
    }

    @Override
    @JsonProperty
    public String message() {
        return this.message;
    }

    public final ImmutableCommit withAuthor(@Nullable UserReference value) {
        if (this.author == value) {
            return this;
        }
        return new ImmutableCommit(value, this.hash, this.url, this.timestamp, this.flags, this.message);
    }

    public final ImmutableCommit withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(this.author, newValue, this.url, this.timestamp, this.flags, this.message);
    }

    public final ImmutableCommit withUrl(@Nullable URL value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableCommit(this.author, this.hash, value, this.timestamp, this.flags, this.message);
    }

    public final ImmutableCommit withTimestamp(Instant value) {
        if (this.timestamp == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "timestamp");
        return new ImmutableCommit(this.author, this.hash, this.url, newValue, this.flags, this.message);
    }

    public final ImmutableCommit withFlags(Commit.Flag ... elements) {
        Set<Commit.Flag> newValue = ImmutableCommit.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableCommit(this.author, this.hash, this.url, this.timestamp, newValue, this.message);
    }

    public final ImmutableCommit withFlags(Iterable<Commit.Flag> elements) {
        if (this.flags == elements) {
            return this;
        }
        Set<Commit.Flag> newValue = ImmutableCommit.createUnmodifiableEnumSet(elements);
        return new ImmutableCommit(this.author, this.hash, this.url, this.timestamp, newValue, this.message);
    }

    public final ImmutableCommit withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCommit(this.author, this.hash, this.url, this.timestamp, this.flags, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommit && this.equalTo((ImmutableCommit)another);
    }

    private boolean equalTo(ImmutableCommit another) {
        return Objects.equals(this.author, another.author) && this.hash.equals(another.hash) && Objects.equals(this.url, another.url) && this.timestamp.equals(another.timestamp) && this.flags.equals(another.flags) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + this.timestamp.hashCode();
        h += (h << 5) + this.flags.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        return "Commit{author=" + this.author + ", hash=" + this.hash + ", url=" + this.url + ", timestamp=" + this.timestamp + ", flags=" + this.flags + ", message=" + this.message + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommit fromJson(Json json) {
        Builder builder = (Builder)ImmutableCommit.builder();
        if (json.authorIsSet) {
            builder.author(json.author);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.urlIsSet) {
            builder.url(json.url);
        }
        if (json.timestamp != null) {
            builder.timestamp(json.timestamp);
        }
        if (json.flags != null) {
            builder.addAllFlags(json.flags);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        return builder.build();
    }

    public static ImmutableCommit copyOf(Commit instance) {
        if (instance instanceof ImmutableCommit) {
            return (ImmutableCommit)instance;
        }
        return ((Builder)((Builder)ImmutableCommit.builder()).author(instance.author()).hash(instance.hash()).url(instance.url()).timestamp(instance.timestamp()).addAllFlags(instance.flags())).message(instance.message()).build();
    }

    public static HashBuildStage builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableCommit.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @Generated(from="Commit", generator="Immutables")
    public static interface BuildFinal {
        public BuildFinal author(@Nullable UserReference var1);

        public BuildFinal url(@Nullable URL var1);

        public BuildFinal addFlags(Commit.Flag var1);

        public BuildFinal addFlags(Commit.Flag ... var1);

        public BuildFinal addAllFlags(Iterable<Commit.Flag> var1);

        public ImmutableCommit build();
    }

    @Generated(from="Commit", generator="Immutables")
    public static interface MessageBuildStage {
        public BuildFinal message(String var1);
    }

    @Generated(from="Commit", generator="Immutables")
    public static interface TimestampBuildStage {
        public MessageBuildStage timestamp(Instant var1);
    }

    @Generated(from="Commit", generator="Immutables")
    public static interface HashBuildStage {
        public TimestampBuildStage hash(String var1);
    }

    @Generated(from="Commit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements HashBuildStage,
    TimestampBuildStage,
    MessageBuildStage,
    BuildFinal {
        private static final long INIT_BIT_HASH = 1L;
        private static final long INIT_BIT_TIMESTAMP = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private static final long OPT_BIT_AUTHOR = 1L;
        private static final long OPT_BIT_URL = 2L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private UserReference author;
        @Nullable
        private String hash;
        @Nullable
        private URL url;
        @Nullable
        private Instant timestamp;
        private final EnumSet<Commit.Flag> flags = EnumSet.noneOf(Commit.Flag.class);
        @Nullable
        private String message;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder author(@Nullable UserReference author) {
            Builder.checkNotIsSet(this.authorIsSet(), "author");
            this.author = author;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(String hash) {
            Builder.checkNotIsSet(this.hashIsSet(), "hash");
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URL url) {
            Builder.checkNotIsSet(this.urlIsSet(), "url");
            this.url = url;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        @CanIgnoreReturnValue
        public final Builder timestamp(Instant timestamp) {
            Builder.checkNotIsSet(this.timestampIsSet(), "timestamp");
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addFlags(Commit.Flag element) {
            this.flags.add(Objects.requireNonNull(element, "flags element"));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addFlags(Commit.Flag ... elements) {
            for (Commit.Flag element : elements) {
                this.flags.add(Objects.requireNonNull(element, "flags element"));
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAllFlags(Iterable<Commit.Flag> elements) {
            for (Commit.Flag element : elements) {
                this.flags.add(Objects.requireNonNull(element, "flags element"));
            }
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            Builder.checkNotIsSet(this.messageIsSet(), "message");
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableCommit build() {
            this.checkRequiredAttributes();
            return new ImmutableCommit(this.author, this.hash, this.url, this.timestamp, ImmutableCommit.createUnmodifiableEnumSet(this.flags), this.message);
        }

        private boolean authorIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean urlIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hashIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean timestampIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean messageIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Commit is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.hashIsSet()) {
                attributes.add("hash");
            }
            if (!this.timestampIsSet()) {
                attributes.add("timestamp");
            }
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            return "Cannot build Commit, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Commit", generator="Immutables")
    static final class Json
    implements Commit {
        @Nullable
        UserReference author;
        boolean authorIsSet;
        @Nullable
        String hash;
        @Nullable
        URL url;
        boolean urlIsSet;
        @Nullable
        Instant timestamp;
        @Nullable
        Set<Commit.Flag> flags = Collections.emptySet();
        @Nullable
        String message;

        Json() {
        }

        @JsonProperty
        public void setAuthor(@Nullable UserReference author) {
            this.author = author;
            this.authorIsSet = true;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @JsonProperty
        public void setUrl(@Nullable URL url) {
            this.url = url;
            this.urlIsSet = true;
        }

        @JsonProperty
        @JsonSerialize(using=InstantToIso861Serializer.class)
        @JsonDeserialize(using=InstantToIso861Deserializer.class)
        public void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty
        public void setFlags(Set<Commit.Flag> flags) {
            this.flags = flags;
        }

        @JsonProperty
        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public UserReference author() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URL url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant timestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Commit.Flag> flags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }
    }
}

