/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.ProviderReference;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ProviderReference", generator="Immutables")
@Immutable
public final class ImmutableProviderReference
implements ProviderReference {
    private final String id;
    private final String name;
    @Nullable
    private final URI url;
    @Nullable
    private final URI logoUrl;

    private ImmutableProviderReference(String id, String name, @Nullable URI url, @Nullable URI logoUrl) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.logoUrl = logoUrl;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI url() {
        return this.url;
    }

    @Override
    @JsonProperty
    @Nullable
    public URI logoUrl() {
        return this.logoUrl;
    }

    public final ImmutableProviderReference withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableProviderReference(newValue, this.name, this.url, this.logoUrl);
    }

    public final ImmutableProviderReference withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableProviderReference(this.id, newValue, this.url, this.logoUrl);
    }

    public final ImmutableProviderReference withUrl(@Nullable URI value) {
        if (this.url == value) {
            return this;
        }
        return new ImmutableProviderReference(this.id, this.name, value, this.logoUrl);
    }

    public final ImmutableProviderReference withLogoUrl(@Nullable URI value) {
        if (this.logoUrl == value) {
            return this;
        }
        return new ImmutableProviderReference(this.id, this.name, this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProviderReference && this.equalTo((ImmutableProviderReference)another);
    }

    private boolean equalTo(ImmutableProviderReference another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.url, another.url) && Objects.equals(this.logoUrl, another.logoUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.logoUrl);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ProviderReference").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("url", (Object)this.url).add("logoUrl", (Object)this.logoUrl).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableProviderReference fromJson(Json json) {
        Builder builder = (Builder)ImmutableProviderReference.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.urlIsSet) {
            builder.url(json.url);
        }
        if (json.logoUrlIsSet) {
            builder.logoUrl(json.logoUrl);
        }
        return builder.build();
    }

    public static ImmutableProviderReference copyOf(ProviderReference instance) {
        if (instance instanceof ImmutableProviderReference) {
            return (ImmutableProviderReference)instance;
        }
        return ((Builder)ImmutableProviderReference.builder()).id(instance.id()).name(instance.name()).url(instance.url()).logoUrl(instance.logoUrl()).build();
    }

    public static IdBuildStage builder() {
        return new Builder();
    }

    @Generated(from="ProviderReference", generator="Immutables")
    public static interface BuildFinal {
        public BuildFinal url(@Nullable URI var1);

        public BuildFinal logoUrl(@Nullable URI var1);

        public ImmutableProviderReference build();
    }

    @Generated(from="ProviderReference", generator="Immutables")
    public static interface NameBuildStage {
        public BuildFinal name(String var1);
    }

    @Generated(from="ProviderReference", generator="Immutables")
    public static interface IdBuildStage {
        public NameBuildStage id(String var1);
    }

    @Generated(from="ProviderReference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements IdBuildStage,
    NameBuildStage,
    BuildFinal {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_URL = 1L;
        private static final long OPT_BIT_LOGO_URL = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private URI url;
        @Nullable
        private URI logoUrl;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            Builder.checkNotIsSet(this.idIsSet(), "id");
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder url(@Nullable URI url) {
            Builder.checkNotIsSet(this.urlIsSet(), "url");
            this.url = url;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder logoUrl(@Nullable URI logoUrl) {
            Builder.checkNotIsSet(this.logoUrlIsSet(), "logoUrl");
            this.logoUrl = logoUrl;
            this.optBits |= 2L;
            return this;
        }

        @Override
        public ImmutableProviderReference build() {
            this.checkRequiredAttributes();
            return new ImmutableProviderReference(this.id, this.name, this.url, this.logoUrl);
        }

        private boolean urlIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logoUrlIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of ProviderReference is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build ProviderReference, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ProviderReference", generator="Immutables")
    static final class Json
    implements ProviderReference {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        URI url;
        boolean urlIsSet;
        @Nullable
        URI logoUrl;
        boolean logoUrlIsSet;

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setUrl(@Nullable URI url) {
            this.url = url;
            this.urlIsSet = true;
        }

        @JsonProperty
        public void setLogoUrl(@Nullable URI logoUrl) {
            this.logoUrl = logoUrl;
            this.logoUrlIsSet = true;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public URI logoUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

