/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.Association;
import com.atlassian.devops.schemas.BasicAssociationType;
import com.atlassian.devops.schemas.BranchCreated;
import com.atlassian.devops.schemas.ImmutableBasicAssociation;
import com.atlassian.devops.schemas.ImmutableBranch;
import com.atlassian.devops.schemas.ImmutableBranchCreated;
import com.atlassian.devops.schemas.ImmutableEntityAssociation;
import com.atlassian.devops.schemas.ImmutableIssueAssociation;
import com.atlassian.devops.schemas.ImmutableProviderReference;
import com.atlassian.devops.schemas.ImmutableRepositoryReference;
import com.atlassian.devops.schemas.ImmutableTenantReference;
import com.atlassian.devops.schemas.ImmutableTrackingReference;
import com.atlassian.devops.schemas.ImmutableUserReference;
import com.atlassian.devops.schemas.IssueAssociationType;
import com.atlassian.devops.schemas.TrackingReference;
import com.atlassian.devops.schemas.commit.Commit;
import com.atlassian.devops.schemas.commit.CommitCreated;
import com.atlassian.devops.schemas.commit.ImmutableCommit;
import com.atlassian.devops.schemas.commit.ImmutableCommitCreated;
import com.atlassian.devops.schemas.pullrequest.BranchReference;
import com.atlassian.devops.schemas.pullrequest.ImmutableBranchReference;
import com.atlassian.devops.schemas.pullrequest.ImmutablePullRequest;
import com.atlassian.devops.schemas.pullrequest.ImmutablePullRequestCreated;
import com.atlassian.devops.schemas.pullrequest.ImmutablePullRequestDeclined;
import com.atlassian.devops.schemas.pullrequest.ImmutablePullRequestMerged;
import com.atlassian.devops.schemas.pullrequest.PullRequest;
import com.atlassian.devops.schemas.pullrequest.PullRequestEvent;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;

public class Examples {
    @Deprecated
    public static BranchCreated EXAMPLE_1 = Examples.generateBranchCreated();

    public static BranchCreated generateBranchCreated() {
        return ImmutableBranchCreated.builder().repository(Examples.getRepository()).provider(Examples.getProvider()).branch(Examples.getBranch("one")).associations(Examples.getAssociation()).tracking(Examples.getTracking()).build();
    }

    public static CommitCreated generateCommitCreated(Commit.Flag ... flags) {
        return ImmutableCommitCreated.builder().commit(Examples.getCommit(flags)).repository(Examples.getRepository()).provider(Examples.getProvider()).associations(Examples.getAssociation()).tracking(Examples.getTracking()).build();
    }

    public static PullRequestEvent generatePullRequestCreated() {
        return ImmutablePullRequestCreated.builder().pullRequest(Examples.getPullRequest(PullRequest.State.OPEN)).provider(Examples.getProvider()).associations(Examples.getAssociation()).repository(Examples.getRepository()).tracking(Examples.getTracking()).build();
    }

    public static PullRequestEvent generatePullRequestMerged() {
        return ImmutablePullRequestMerged.builder().pullRequest(Examples.getPullRequest(PullRequest.State.MERGED)).provider(Examples.getProvider()).associations(Examples.getAssociation()).repository(Examples.getRepository()).tracking(Examples.getTracking()).build();
    }

    public static PullRequestEvent generatePullRequestDeclined() {
        return ImmutablePullRequestDeclined.builder().pullRequest(Examples.getPullRequest(PullRequest.State.DECLINED)).provider(Examples.getProvider()).associations(Examples.getAssociation()).repository(Examples.getRepository()).tracking(Examples.getTracking()).build();
    }

    private static ImmutableBranch getBranch(String name) {
        return ImmutableBranch.builder().name(name).url(Examples.getUrlSafe("https://bitbucket.org/accnt/repo/" + name)).lastCommitTimestamp(Instant.now()).build();
    }

    private static PullRequest getPullRequest(PullRequest.State state) {
        return ImmutablePullRequest.builder().id("123").title("Please add this PR").url(Examples.getUrlSafe("https://bitbucket.org/pr/aaa")).state(state).updatedDate(Instant.now()).commentCount(1).sourceBranch(Examples.getPullRequestBranch("source")).destinationBranch(Examples.getPullRequestBranch("destination")).build();
    }

    private static BranchReference getPullRequestBranch(String name) {
        return ImmutableBranchReference.builder().name(name).url(Examples.getUrlSafe("https://bitbucket.org/accnt/repo/" + name)).build();
    }

    private static TrackingReference getTracking() {
        return ImmutableTrackingReference.builder().traceId("123456789").timestamp(Instant.now()).build();
    }

    private static ImmutableRepositoryReference getRepository() {
        return ImmutableRepositoryReference.builder().id("{abc-123}").name("my-cool-repo").url(Examples.getUriSafe("https://bitbucket.org/accnt/repo")).build();
    }

    private static ImmutableProviderReference getProvider() {
        return ImmutableProviderReference.builder().id("bitbucket-cloud").name("Bitbucket Cloud").url(Examples.getUriSafe("https://bitbucket.org/")).logoUrl(Examples.getUriSafe("https://bitbucket.org/logo")).build();
    }

    private static ImmutableEntityAssociation getAssociation() {
        return ImmutableEntityAssociation.builder().addCurrent((Association)ImmutableIssueAssociation.builder().type(IssueAssociationType.JIRA_ISSUE).id("10001").ari("ari:cloud:jira:1111-2222-333:issue/10001").tenant(ImmutableTenantReference.builder().cloudId("111-222-333").activationId("444-555-666").build()).build()).addCurrent((Association)ImmutableBasicAssociation.builder().type(BasicAssociationType.DEVOPS_SERVICE).id("service-45879").ari("ari:cloud:service-registry::service/service-45879").build()).build();
    }

    private static Commit getCommit(Commit.Flag ... flags) {
        return ImmutableCommit.builder().hash("4877576951f3eda43625d3345058e702dad3df0d").timestamp(Instant.now()).message("awesome change").url(Examples.getUrlSafe("https://bitbucket.org/commit/asdf")).author(ImmutableUserReference.builder().accountId("123").build()).addFlags(flags).build();
    }

    private static URI getUriSafe(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private static URL getUrlSafe(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

