package com.atlassian.data.markov

import com.atlassian.data.ValuesWithFrequencies

class MarkovChainGenerator(
    private val valueLinks: Map<Int, ValuesWithFrequencies<Int>>
) {
    companion object {
        const val CHAIN_START = 0
        const val CHAIN_END = CHAIN_START + 1
    }

    private fun collectionSize(list: Collection<Int>) : Int {
       return list.size
    }

    fun generateChain(minLength: Int, preferredLength: Int, lengthCalculator: (m: Collection<Int>) -> Int = ::collectionSize ): List<Int> {
        val chain = mutableListOf<Int>()

        var nextValues = valueLinks[CHAIN_START]!!
        while (true) {
            val randomValue =
                if (preferredLength == Int.MAX_VALUE && lengthCalculator(chain)>=minLength)
                    nextValues.pickRandom()
                else
                    nextValues.pickRandomTryToAvoid(CHAIN_END)

            if (randomValue == CHAIN_END) {
                break
            }
            chain.add(randomValue)

            nextValues = valueLinks[randomValue]!!

            if (lengthCalculator(chain) >= preferredLength && nextValues.hasValue(CHAIN_END)) {
                break
            }
        }
        return chain
    }
}

