/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ConnectionPoolPropertyConstants {
    public static final String POOL_INITIAL_SIZE = "com.sun.jndi.ldap.connect.pool.initsize";
    public static final String POOL_MAXIMUM_SIZE = "com.sun.jndi.ldap.connect.pool.maxsize";
    public static final String POOL_PREFERRED_SIZE = "com.sun.jndi.ldap.connect.pool.prefsize";
    public static final String POOL_PROTOCOL = "com.sun.jndi.ldap.connect.pool.protocol";
    public static final String POOL_TIMEOUT = "com.sun.jndi.ldap.connect.pool.timeout";
    public static final String POOL_AUTHENTICATION = "com.sun.jndi.ldap.connect.pool.authentication";
    public static final String DEFAULT_INITIAL_POOL_SIZE = "1";
    public static final String DEFAULT_MAXIMUM_POOL_SIZE = "0";
    public static final String DEFAULT_PREFERRED_POOL_SIZE = "0";
    public static final String DEFAULT_POOL_TIMEOUT_MS = String.valueOf(Duration.ofMinutes(5L).toMillis());
    public static final String DEFAULT_POOL_PROTOCOL = "plain ssl";
    public static final String DEFAULT_POOL_AUTHENTICATION = "simple";
    public static final Set<String> VALID_PROTOCOL_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("plain", "ssl")));
    public static final Set<String> VALID_AUTHENTICATION_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("none", "simple", "DIGEST-MD5")));
    public static final Map<String, String> DEFAULT_PROPERTIES;

    private ConnectionPoolPropertyConstants() {
    }

    static {
        HashMap<String, String> aMap = new HashMap<String, String>();
        aMap.put(POOL_INITIAL_SIZE, DEFAULT_INITIAL_POOL_SIZE);
        aMap.put(POOL_MAXIMUM_SIZE, "0");
        aMap.put(POOL_PREFERRED_SIZE, "0");
        aMap.put(POOL_TIMEOUT, DEFAULT_POOL_TIMEOUT_MS);
        aMap.put(POOL_PROTOCOL, DEFAULT_POOL_PROTOCOL);
        aMap.put(POOL_AUTHENTICATION, DEFAULT_POOL_AUTHENTICATION);
        DEFAULT_PROPERTIES = Collections.unmodifiableMap(aMap);
    }
}

