/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.api;

import com.atlassian.crowd.embedded.api.PasswordPolicyConfiguration;
import java.util.stream.Stream;

public enum PasswordPolicyConfigurationPreset {
    DISABLED(PasswordPolicyConfigurationPreset.getEmptyConfigurationBuilder()),
    RECOMMENDED(PasswordPolicyConfigurationPreset.getRecommendedConfigurationBuilder()),
    CUSTOM(PasswordPolicyConfigurationPreset.getEmptyConfigurationBuilder());

    private final PasswordPolicyConfiguration.PasswordPolicyConfigurationBuilder configurationBuilder;

    private PasswordPolicyConfigurationPreset(PasswordPolicyConfiguration.PasswordPolicyConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }

    public static boolean hasValue(String name) {
        return Stream.of(PasswordPolicyConfigurationPreset.values()).anyMatch(value -> value.name().equals(name));
    }

    public PasswordPolicyConfiguration buildPasswordPolicyConfiguration() {
        return this.configurationBuilder.preset(this).build();
    }

    private static PasswordPolicyConfiguration.PasswordPolicyConfigurationBuilder getEmptyConfigurationBuilder() {
        return PasswordPolicyConfiguration.builder();
    }

    private static PasswordPolicyConfiguration.PasswordPolicyConfigurationBuilder getRecommendedConfigurationBuilder() {
        return PasswordPolicyConfiguration.builder().minimumLength(8);
    }
}

