package com.atlassian.crowd.embedded.api;

import java.util.Collection;

/**
 * Analyses passwords to provide an estimate of their strength.
 */
public interface PasswordScoreService {
    /**
     * Analyse a non-encrypted password and determine the score of it according to some method (e.g. based on the amount
     * of entropy in the password).
     *
     * @param passwordCredential The credential to analyse.
     * @param userInfo           a collection of user-specific information to use when scoring (display name, email, etc)
     * @return A score for the password strength, or UNKNOWN if the password of {@code passwordCredential} is encrypted
     * or the implementation is unable to determine a password score (including but not limited to encountering
     * an error).
     */
    public PasswordScore getPasswordScore(PasswordCredential passwordCredential, Collection<String> userInfo);
}
