/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.ldap;

import com.atlassian.crowd.embedded.admin.ldap.LdapConnectionPoolValidator;
import com.atlassian.crowd.embedded.admin.util.HtmlEncoder;
import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.impl.DefaultConnectionPoolProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Map;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/configure/connection-pool/**"})
public class LdapConnectionPoolController {
    private static final String FORM_VIEW = "connection-pool-form";
    private static final String POOL_PROPERTIES = "poolProperties";
    @Autowired
    private CrowdDirectoryService crowdDirectoryService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private I18nResolver i18nResolver;
    @Autowired
    private HtmlEncoder htmlEncoder;

    @InitBinder(value={"poolProperties"})
    protected void initConnectionPoolPropertiesValidator(WebDataBinder binder) {
        binder.setValidator((Validator)new LdapConnectionPoolValidator());
    }

    @ModelAttribute(value="systemPoolProperties")
    public ConnectionPoolProperties getSystemPoolProperties() {
        return this.crowdDirectoryService.getSystemConnectionPoolProperties();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String initializeForm(ModelMap model) throws Exception {
        model.addAttribute(POOL_PROPERTIES, (Object)this.crowdDirectoryService.getStoredConnectionPoolProperties());
        return FORM_VIEW;
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView saveSettings(@Valid @ModelAttribute(value="poolProperties") DefaultConnectionPoolProperties poolProperties, BindingResult errors) throws Exception {
        Map model = errors.getModel();
        if (errors.hasErrors()) {
            this.revertInvalidValues(poolProperties, errors);
        } else {
            this.saveLdapProperties((ConnectionPoolProperties)poolProperties);
            model.put("saveSuccessful", true);
        }
        return new ModelAndView(FORM_VIEW, model);
    }

    private void saveLdapProperties(final ConnectionPoolProperties poolProperties) {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                LdapConnectionPoolController.this.crowdDirectoryService.setConnectionPoolProperties(poolProperties);
                return null;
            }
        });
    }

    private void revertInvalidValues(DefaultConnectionPoolProperties properties, BindingResult errors) {
        for (FieldError fieldError : errors.getFieldErrors()) {
            if (fieldError.getField().equals("supportedProtocol")) {
                properties.setSupportedProtocol(this.crowdDirectoryService.getStoredConnectionPoolProperties().getSupportedProtocol());
            }
            if (!fieldError.getField().equals("supportedAuthentication")) continue;
            properties.setSupportedAuthentication(this.crowdDirectoryService.getStoredConnectionPoolProperties().getSupportedAuthentication());
        }
        errors.addError(new ObjectError(POOL_PROPERTIES, this.i18nResolver.getText("embedded.crowd.connection.pool.save.fail")));
    }

    @ModelAttribute(value="htmlEncoder")
    public HtmlEncoder getHtmlEncoder() {
        return this.htmlEncoder;
    }
}

