/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.support;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.admin.DirectoryContextHelper;
import com.atlassian.crowd.embedded.admin.support.DirectoryTroubleshooter;
import com.atlassian.crowd.embedded.admin.support.TroubleshootingCommand;
import com.atlassian.crowd.embedded.admin.util.HtmlEncoder;
import com.atlassian.crowd.embedded.admin.util.SimpleMessage;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PermissionOption;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.plugin.web.springmvc.xsrf.SimpleXsrfTokenGenerator;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public final class TroubleshootingController
extends SimpleFormController {
    private static final Logger log = LoggerFactory.getLogger(TroubleshootingController.class);
    private static final String TYPE_KEY_PREFIX = "embedded.crowd.directory.type.";
    private CrowdDirectoryService crowdDirectoryService;
    private HtmlEncoder htmlEncoder;
    private DirectoryContextHelper directoryContextHelper;
    private I18nResolver i18nResolver;
    private LDAPPropertiesMapper ldapPropertiesMapper;
    private DirectoryInstanceLoader directoryInstanceLoader;
    private DirectoryTroubleshooter directoryTroubleshooter;
    private String editView;
    private SimpleXsrfTokenGenerator xsrfTokenGenerator;

    public String getEditView() {
        return this.editView;
    }

    public void setEditView(String editView) {
        this.editView = editView;
    }

    protected Map referenceData(HttpServletRequest request) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("htmlEncoder", this.htmlEncoder);
        try {
            Directory directory = this.directoryContextHelper.getDirectory(request);
            model.put("directoryName", directory.getName());
            model.put("directoryType", this.getTypeName(directory));
            model.put("isUserFromDirectory", this.directoryContextHelper.isContextUserFromDirectory(directory, request));
        }
        catch (DirectoryNotFoundException e) {
            log.error("Directory not found: ", (Throwable)e);
            model.put("errors", Collections.singleton(this.i18nResolver.getText("embedded.crowd.directory.not.found")));
            return model;
        }
        return model;
    }

    protected ModelAndView showForm(HttpServletRequest request, HttpServletResponse response, BindException errors) throws Exception {
        boolean forceTest = Boolean.parseBoolean(request.getParameter("forceTest"));
        if (forceTest) {
            Object command = this.formBackingObject(request);
            return this.onSubmit(request, response, command, errors);
        }
        return super.showForm(request, response, errors);
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        TroubleshootingCommand tCommand = (TroubleshootingCommand)command;
        if (tCommand.redirectToEdit()) {
            String editView = StringUtils.replace((String)this.getEditView(), (String)"{directoryId}", (String)String.valueOf(tCommand.getDirectoryId()));
            String withToken = editView + "&" + this.xsrfTokenGenerator.getXsrfTokenName() + "=" + this.xsrfTokenGenerator.generateToken(request);
            return new ModelAndView(withToken);
        }
        HashMap<String, Iterable<DirectoryTroubleshooter.TestResult>> model = new HashMap<String, Iterable<DirectoryTroubleshooter.TestResult>>();
        RemoteDirectory rawDirectory = null;
        Directory directory = this.crowdDirectoryService.findDirectoryById(tCommand.getDirectoryId());
        if (directory == null) {
            this.addObjectError(errors, "embedded.crowd.directory.not.found", new Serializable[0]);
        } else {
            rawDirectory = this.directoryInstanceLoader.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
        }
        if (rawDirectory == null) {
            this.addObjectError(errors, "embedded.crowd.directory.not.found", new Serializable[0]);
        } else {
            model.put("testResults", this.directoryTroubleshooter.troubleshootDirectory(rawDirectory, tCommand.getUsername(), tCommand.getPassword()));
        }
        return this.showForm(request, response, errors, model);
    }

    public void setCrowdDirectoryService(CrowdDirectoryService CrowdDirectoryService2) {
        this.crowdDirectoryService = CrowdDirectoryService2;
    }

    public void setDirectoryInstanceLoader(DirectoryInstanceLoader directoryInstanceLoader) {
        this.directoryInstanceLoader = directoryInstanceLoader;
    }

    public void setHtmlEncoder(HtmlEncoder htmlEncoder) {
        this.htmlEncoder = htmlEncoder;
    }

    public void setDirectoryContextHelper(DirectoryContextHelper directoryContextHelper) {
        this.directoryContextHelper = directoryContextHelper;
    }

    public void setLdapPropertiesMapper(LDAPPropertiesMapper ldapPropertiesMapper) {
        this.ldapPropertiesMapper = ldapPropertiesMapper;
    }

    public final void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        TroubleshootingCommand command = new TroubleshootingCommand();
        try {
            long directoryId = Long.parseLong(request.getParameter("directoryId"));
            command.setDirectoryId(directoryId);
        }
        catch (NumberFormatException e) {
            command.setDirectoryId(-1L);
        }
        return command;
    }

    private void addObjectError(BindException errors, String message, Serializable ... arguments) {
        errors.addError(new ObjectError("credential", this.i18nResolver.getText(message, arguments)));
    }

    public void setXsrfTokenGenerator(SimpleXsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    private Message getTypeName(Directory directory) {
        DirectoryType directoryType = directory.getType();
        switch (directoryType) {
            case CONNECTOR: {
                String implemntationName = this.getNameForImplementation(directory.getImplementationClass());
                String name = implemntationName == null ? directoryType.name() : implemntationName;
                PermissionOption permissionOption = PermissionOption.fromAllowedOperations((Set)directory.getAllowedOperations());
                return SimpleMessage.instance((String)(TYPE_KEY_PREFIX + directoryType.name() + "." + permissionOption.name()), (Serializable[])new Serializable[]{name});
            }
            case CUSTOM: {
                return SimpleMessage.instance((String)(TYPE_KEY_PREFIX + directoryType.name() + this.getClassNameOnly(directory.getImplementationClass())), (Serializable[])new Serializable[0]);
            }
            case DELEGATING: {
                String implementationClass = directory.getValue("crowd.delegated.directory.type");
                return SimpleMessage.instance((String)(TYPE_KEY_PREFIX + directoryType.name()), (Serializable[])new Serializable[]{this.getNameForImplementation(implementationClass)});
            }
        }
        return SimpleMessage.instance((String)(TYPE_KEY_PREFIX + directoryType.name()), (Serializable[])new Serializable[0]);
    }

    private String getNameForImplementation(String implementationClass) {
        Map implementations = this.ldapPropertiesMapper.getImplementations();
        for (Map.Entry entry : implementations.entrySet()) {
            if (!((String)entry.getValue()).equals(implementationClass)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    private String getClassNameOnly(String implementationClass) {
        return implementationClass.substring(implementationClass.lastIndexOf("."));
    }

    public void setDirectoryTroubleshooter(DirectoryTroubleshooter directoryTroubleshooter) {
        this.directoryTroubleshooter = directoryTroubleshooter;
    }
}

