/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.ldap;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.LdapTypeConfig;
import com.atlassian.crowd.embedded.admin.ConfigurationController;
import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.plugin.PermissionOptionResolver;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PermissionOption;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.ServletRequestDataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LdapConfigurationController
extends ConfigurationController {
    private PasswordEncoderFactory passwordEncoderFactory;
    private LDAPPropertiesMapper ldapPropertiesMapper;
    private PermissionOptionResolver permissionOptionResolver;

    @Override
    protected Map referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("ldapDirectoryTypes", this.getLdapDirectoryTypes());
        model.put("ldapTypeConfigurations", this.getLdapTypeConfigurations());
        model.put("ldapPermissionOptions", this.getLdapPermissionOptions());
        model.put("ldapPasswordEncryptionTypes", this.getPasswordEncryptionTypes());
        return model;
    }

    @Override
    protected Directory createDirectory(Object command) {
        return this.directoryMapper.buildLdapDirectory((LdapDirectoryConfiguration)command);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        if (this.directoryContextHelper.hasDirectoryId(request)) {
            Directory directory = this.directoryContextHelper.getDirectory(request);
            return this.directoryMapper.toLdapConfiguration(directory);
        }
        LdapDirectoryConfiguration configuration = (LdapDirectoryConfiguration)this.createCommand();
        if (request.getPathInfo().endsWith("/activedirectory/")) {
            configuration.setType("com.atlassian.crowd.directory.MicrosoftActiveDirectory");
            configuration.setName(this.getI18nResolver().getText("embedded.crowd.directory.edit.ldap.field.default.ad"));
        } else {
            configuration.setName(this.getI18nResolver().getText("embedded.crowd.directory.edit.ldap.field.default.ldap"));
        }
        configuration.setLdapAutoAddGroups(this.getDefaultLdapAutoAddGroups());
        return configuration;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        super.initBinder(request, binder);
        binder.setRequiredFields(new String[]{"name", "type", "hostname", "port", "ldapPermissionOption", "ldapUserObjectclass", "ldapUserFilter", "ldapUserUsername", "ldapUserFirstname", "ldapUserLastname", "ldapUserDisplayname", "ldapUserEmail", "ldapUserGroup", "ldapUserPassword", "ldapGroupObjectclass", "ldapGroupFilter", "ldapGroupName", "ldapGroupDescription", "ldapGroupUsernames", "ldapCacheSynchroniseIntervalInMin"});
    }

    private Map<String, String> getLdapDirectoryTypes() {
        LinkedHashMap<String, String> directoryTypes = new LinkedHashMap<String, String>();
        Map implementations = this.ldapPropertiesMapper.getImplementations();
        for (Map.Entry implementation : implementations.entrySet()) {
            directoryTypes.put((String)implementation.getValue(), (String)implementation.getKey());
        }
        return directoryTypes;
    }

    private List<String> getLdapPermissionOptions() {
        ArrayList<String> options = new ArrayList<String>();
        for (PermissionOption option : this.permissionOptionResolver.getEnabledPermissionOptions()) {
            options.add(option.name());
        }
        return options;
    }

    private List<LdapTypeConfig> getLdapTypeConfigurations() {
        return this.ldapPropertiesMapper.getLdapTypeConfigurations();
    }

    public Map<String, String> getPasswordEncryptionTypes() {
        LinkedHashMap<String, String> encryptionTypes = new LinkedHashMap<String, String>();
        for (String encoder : this.passwordEncoderFactory.getSupportedLdapEncoders()) {
            encryptionTypes.put(encoder, encoder.toUpperCase());
        }
        return encryptionTypes;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public void setLdapPropertiesMapper(LDAPPropertiesMapper ldapPropertiesMapper) {
        this.ldapPropertiesMapper = ldapPropertiesMapper;
    }

    public void setPermissionOptionResolver(PermissionOptionResolver permissionOptionResolver) {
        this.permissionOptionResolver = permissionOptionResolver;
    }
}

