/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.directory;

import com.atlassian.crowd.embedded.admin.directory.MigrateDirectoryUsersCommand;
import com.atlassian.crowd.embedded.admin.util.HtmlEncoder;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigrateDirectoryUsersController
extends SimpleFormController {
    private static final Logger log = LoggerFactory.getLogger(MigrateDirectoryUsersController.class);
    private CrowdDirectoryService crowdDirectoryService;
    private UserManager userManager;
    private I18nResolver i18nResolver;
    private TransactionTemplate transactionTemplate;
    private HtmlEncoder htmlEncoder;
    private DirectoryManager directoryManager;
    private ApplicationProperties applicationProperties;

    protected Map referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("htmlEncoder", this.htmlEncoder);
        model.put("directories", this.getDirectories());
        return model;
    }

    private Map<String, String> getDirectories() {
        LinkedHashMap<String, String> directories = new LinkedHashMap<String, String>();
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (directory.getType() != DirectoryType.INTERNAL && directory.getType() != DirectoryType.DELEGATING) continue;
            directories.put(directory.getId().toString(), directory.getName());
        }
        return directories;
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        return this.createCommand();
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        String remoteUser = this.userManager.getRemoteUsername(request);
        MigrateDirectoryUsersCommand migrateUsersCommand = (MigrateDirectoryUsersCommand)command;
        this.migrateUsers(migrateUsersCommand.getFromDirectoryId(), migrateUsersCommand.getToDirectoryId(), remoteUser, migrateUsersCommand, errors);
        if (errors.hasErrors()) {
            return this.showForm(request, response, errors, this.referenceData(request));
        }
        return this.showForm(request, response, errors, this.referenceData(request));
    }

    private void migrateUsers(final long fromDirectoryId, final long toDirectoryId, final String remoteUser, MigrateDirectoryUsersCommand migrateUsersCommand, BindException errors) {
        Directory from = this.validateDirectory(fromDirectoryId, errors, "fromDirectoryId");
        Directory to = this.validateDirectory(toDirectoryId, errors, "toDirectoryId");
        if (to != null && to.equals(from)) {
            errors.addError((ObjectError)new FieldError("migration", "toDirectoryId", this.i18nResolver.getText("embedded.crowd.directory.migrate.users.field.directory.same")));
        }
        if (errors.hasErrors()) {
            return;
        }
        this.setDirectoryEnabled(from, false);
        this.setDirectoryEnabled(to, false);
        NullRestriction restriction = NullRestrictionImpl.INSTANCE;
        UserQuery query = new UserQuery(User.class, (SearchRestriction)restriction, 0, -1);
        try {
            List users = this.directoryManager.searchUsers(fromDirectoryId, (EntityQuery)query);
            final AtomicLong migratedCount = new AtomicLong(0L);
            for (final User user : users) {
                this.transactionTemplate.execute(new TransactionCallback(){

                    public Object doInTransaction() {
                        try {
                            MigrateDirectoryUsersController.this.migrateUser(fromDirectoryId, toDirectoryId, remoteUser, user, migratedCount);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
            }
            migrateUsersCommand.setTestSuccessful(true);
            migrateUsersCommand.setTotalCount(users.size());
            migrateUsersCommand.setMigratedCount(migratedCount.get());
        }
        catch (Exception e) {
            log.error("User migration failed", (Throwable)e);
            errors.addError(new ObjectError("migration", this.i18nResolver.getText("embedded.crowd.directory.migrate.users.error", new Serializable[]{this.htmlEncoder.encode(e.getMessage())})));
        }
        this.setDirectoryEnabled(from, true);
        this.setDirectoryEnabled(to, true);
    }

    private void migrateUser(long fromDirectoryId, long toDirectoryId, String remoteUser, User user, AtomicLong migratedCount) throws Exception {
        if (!user.getName().equalsIgnoreCase(remoteUser)) {
            UserWithAttributes userWithAttributes = this.directoryManager.findUserWithAttributesByName(fromDirectoryId, user.getName());
            try {
                UserTemplate newUser = new UserTemplate(user);
                newUser.setDirectoryId(toDirectoryId);
                this.directoryManager.addUser(toDirectoryId, newUser, new PasswordCredential(MigrateDirectoryUsersController.generatePassword()));
            }
            catch (InvalidUserException e) {
                return;
            }
            Set keys = userWithAttributes.getKeys();
            HashMap<String, Set> attributes = new HashMap<String, Set>();
            for (String key : keys) {
                Set values = userWithAttributes.getValues(key);
                attributes.put(key, values);
            }
            this.directoryManager.storeUserAttributes(toDirectoryId, user.getName(), attributes);
            MembershipQuery groupQuery = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(-1);
            List groups = this.directoryManager.searchDirectGroupRelationships(fromDirectoryId, groupQuery);
            for (Group group : groups) {
                try {
                    this.directoryManager.findGroupByName(toDirectoryId, group.getName());
                }
                catch (GroupNotFoundException ex) {
                    GroupTemplate newGroup = new GroupTemplate(group);
                    newGroup.setDirectoryId(toDirectoryId);
                    this.directoryManager.addGroup(toDirectoryId, newGroup);
                }
                this.directoryManager.addUserToGroup(toDirectoryId, user.getName(), group.getName());
                this.directoryManager.removeUserFromGroup(fromDirectoryId, user.getName(), group.getName());
            }
            this.directoryManager.removeUser(fromDirectoryId, user.getName());
            migratedCount.addAndGet(1L);
        }
    }

    private Directory validateDirectory(Long directoryId, BindException errors, String field) {
        if (directoryId == -1L) {
            errors.addError((ObjectError)new FieldError("migration", field, this.i18nResolver.getText("embedded.crowd.directory.migrate.users.field.directory.required")));
            return null;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(directoryId.longValue());
        if (directory == null) {
            errors.addError((ObjectError)new FieldError("migration", field, this.i18nResolver.getText("embedded.crowd.directory.migrate.users.field.directory.not.found")));
        } else {
            Set allowedOperations;
            if (directory.getType() != DirectoryType.INTERNAL && directory.getType() != DirectoryType.DELEGATING) {
                errors.addError((ObjectError)new FieldError("migration", field, this.i18nResolver.getText("embedded.crowd.directory.migrate.users.field.directory.wrong.type")));
            }
            if (!((allowedOperations = directory.getAllowedOperations()).contains(OperationType.CREATE_USER) && allowedOperations.contains(OperationType.CREATE_GROUP) && allowedOperations.contains(OperationType.DELETE_USER) && allowedOperations.contains(OperationType.DELETE_GROUP))) {
                errors.addError((ObjectError)new FieldError("migration", field, this.i18nResolver.getText("embedded.crowd.directory.migrate.users.field.directory.read.only")));
            }
        }
        return directory;
    }

    private void setDirectoryEnabled(final Directory from, final boolean enabled) {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)from);
                builder.setActive(enabled);
                Directory updatedDirectory = builder.toDirectory();
                MigrateDirectoryUsersController.this.crowdDirectoryService.updateDirectory(updatedDirectory);
                log.info("User directory {}: [ {} ], type: [ {} ]", (Object[])new String[]{enabled ? "enabled" : "disabled", from.getName(), from.getType().toString()});
                return null;
            }
        });
    }

    public static String generatePassword() {
        Random random = new Random();
        return new BigInteger(130, random).toString(32) + "ABab23";
    }

    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public HtmlEncoder getHtmlEncoder() {
        return this.htmlEncoder;
    }

    public void setHtmlEncoder(HtmlEncoder htmlEncoder) {
        this.htmlEncoder = htmlEncoder;
    }

    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public ApplicationProperties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

