/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.delegatingldap;

import com.atlassian.crowd.directory.GenericLDAP;
import com.atlassian.crowd.embedded.admin.delegatingldap.DelegatingLdapDirectoryConfiguration;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

public final class DelegatingLdapDirectoryConfigurationValidator
implements Validator {
    public boolean supports(Class clazz) {
        return DelegatingLdapDirectoryConfiguration.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        DelegatingLdapDirectoryConfiguration configuration = (DelegatingLdapDirectoryConfiguration)target;
        if (configuration.getLdapAutoAddGroups().indexOf(124) != -1) {
            errors.rejectValue("ldapAutoAddGroups", "invalid");
        }
        if (configuration.isCreateUserOnAuth()) {
            this.validateCreateUserOnAuthFields(configuration, errors);
            if (configuration.isSynchroniseGroupMemberships()) {
                this.validateSynchroniseGroupMembershipsFields(configuration, errors);
            }
        }
        if (!GenericLDAP.class.getName().equals(configuration.getType())) {
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"ldapBasedn", (String)"required");
        }
    }

    private void validateSynchroniseGroupMembershipsFields(DelegatingLdapDirectoryConfiguration configuration, Errors errors) {
        if (configuration.getLdapGroupObjectclass().isEmpty()) {
            errors.rejectValue("ldapGroupObjectclass", "required");
        }
        if (configuration.getLdapGroupFilter().isEmpty()) {
            errors.rejectValue("ldapGroupFilter", "required");
        }
        if (configuration.getLdapGroupName().isEmpty()) {
            errors.rejectValue("ldapGroupName", "required");
        }
        if (configuration.getLdapGroupDescription().isEmpty()) {
            errors.rejectValue("ldapGroupDescription", "required");
        }
        if (configuration.getLdapGroupUsernames().isEmpty()) {
            errors.rejectValue("ldapGroupUsernames", "required");
        }
        if (configuration.getLdapUserGroup().isEmpty()) {
            errors.rejectValue("ldapUserGroup", "required");
        }
    }

    private void validateCreateUserOnAuthFields(DelegatingLdapDirectoryConfiguration configuration, Errors errors) {
        if (configuration.getLdapUserObjectclass().isEmpty()) {
            errors.rejectValue("ldapUserObjectclass", "required");
        }
        if (configuration.getLdapUserFilter().isEmpty()) {
            errors.rejectValue("ldapUserFilter", "required");
        }
        if (configuration.getLdapUserUsername().isEmpty()) {
            errors.rejectValue("ldapUserUsername", "required");
        }
        if (configuration.getLdapUserUsernameRdn().isEmpty()) {
            errors.rejectValue("ldapUserUsernameRdn", "required");
        }
        if (configuration.getLdapUserFirstname().isEmpty()) {
            errors.rejectValue("ldapUserFirstname", "required");
        }
        if (configuration.getLdapUserLastname().isEmpty()) {
            errors.rejectValue("ldapUserLastname", "required");
        }
        if (configuration.getLdapUserDisplayname().isEmpty()) {
            errors.rejectValue("ldapUserDisplayname", "required");
        }
        if (configuration.getLdapUserEmail().isEmpty()) {
            errors.rejectValue("ldapUserEmail", "required");
        }
    }
}

