/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.delegatingldap;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.LdapTypeConfig;
import com.atlassian.crowd.embedded.admin.ConfigurationController;
import com.atlassian.crowd.embedded.admin.delegatingldap.DelegatingLdapDirectoryConfiguration;
import com.atlassian.crowd.embedded.api.Directory;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.ServletRequestDataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DelegatingLdapConfigurationController
extends ConfigurationController {
    private static final Logger log = LoggerFactory.getLogger(DelegatingLdapConfigurationController.class);
    private LDAPPropertiesMapper ldapPropertiesMapper;

    @Override
    protected Map referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("ldapDirectoryTypes", this.getLdapDirectoryTypes());
        model.put("ldapTypeConfigurations", this.getLdapTypeConfigurations());
        return model;
    }

    @Override
    protected Directory createDirectory(Object command) {
        return this.directoryMapper.buildDelegatingLdapDirectory((DelegatingLdapDirectoryConfiguration)command);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        if (this.directoryContextHelper.hasDirectoryId(request)) {
            Directory directory = this.directoryContextHelper.getDirectory(request);
            return this.directoryMapper.toDelegatingLdapConfiguration(directory);
        }
        DelegatingLdapDirectoryConfiguration configuration = (DelegatingLdapDirectoryConfiguration)this.createCommand();
        configuration.setLdapAutoAddGroups(this.getDefaultLdapAutoAddGroups());
        return configuration;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        super.initBinder(request, binder);
        binder.setRequiredFields(new String[]{"name", "type", "hostname", "port", "ldapUserUsername"});
    }

    private Map<String, String> getLdapDirectoryTypes() {
        LinkedHashMap<String, String> directoryTypes = new LinkedHashMap<String, String>();
        Map implementations = this.ldapPropertiesMapper.getImplementations();
        for (Map.Entry implementation : implementations.entrySet()) {
            directoryTypes.put((String)implementation.getValue(), (String)implementation.getKey());
        }
        return directoryTypes;
    }

    private List<LdapTypeConfig> getLdapTypeConfigurations() {
        return this.ldapPropertiesMapper.getLdapTypeConfigurations();
    }

    public void setLdapPropertiesMapper(LDAPPropertiesMapper ldapPropertiesMapper) {
        this.ldapPropertiesMapper = ldapPropertiesMapper;
    }
}

