/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin;

import com.atlassian.crowd.embedded.admin.DirectoryContextHelper;
import com.atlassian.crowd.embedded.admin.DirectoryMapper;
import com.atlassian.crowd.embedded.admin.plugin.DefaultGroupsModuleDescriptor;
import com.atlassian.crowd.embedded.admin.util.ConfigurationWithPassword;
import com.atlassian.crowd.embedded.admin.util.HtmlEncoder;
import com.atlassian.crowd.embedded.admin.util.MapBuilder;
import com.atlassian.crowd.embedded.admin.util.PasswordRestoreUtil;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;
import org.springframework.web.util.WebUtils;

public abstract class ConfigurationController
extends SimpleFormController {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationController.class);
    private CrowdDirectoryService crowdDirectoryService;
    protected DirectoryMapper directoryMapper;
    protected DirectoryContextHelper directoryContextHelper;
    private I18nResolver i18nResolver;
    private TransactionTemplate transactionTemplate;
    private HtmlEncoder htmlEncoder;
    private DirectoryManager directoryManager;
    private PluginAccessor pluginAccessor;
    private PasswordRestoreUtil passwordRestoreUtil;

    protected Map referenceData(HttpServletRequest request) throws Exception {
        return MapBuilder.build((Object)"htmlEncoder", (Object)this.htmlEncoder);
    }

    protected final ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        Directory directory = this.createDirectoryFromCommand(command);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("htmlEncoder", this.htmlEncoder);
        if (WebUtils.hasSubmitParameter((ServletRequest)request, (String)"save")) {
            try {
                Directory savedDirectory = this.saveDirectory(directory);
                String successView = StringUtils.replace((String)this.getSuccessView(), (String)"{directoryId}", (String)String.valueOf(savedDirectory.getId()));
                return new ModelAndView(successView, errors.getModel());
            }
            catch (DirectoryInstantiationException e) {
                String error = this.htmlEncoder.encode(e.getMessage());
                this.addObjectError(errors, "embedded.crowd.save.directory.failed", new Serializable[]{error});
            }
        } else if (WebUtils.hasSubmitParameter((ServletRequest)request, (String)"test")) {
            try {
                this.crowdDirectoryService.testConnection(directory);
                log.info("Configuration test successful for user directory: [ {} ], type: [ {} ]", (Object)directory.getName(), (Object)directory.getType());
                model.put("testSuccessful", true);
                model.put("successMessage", this.i18nResolver.getText("embedded.crowd.connection.test.successful"));
                model.put("successMessage", this.i18nResolver.getText("embedded.crowd.connection.test.successful.caution"));
            }
            catch (OperationFailedException e) {
                log.error("Configuration test failed for user directory: [ " + directory.getName() + "], " + "type: [ " + directory.getType() + " ]", (Throwable)e);
                String rawMessage = e.getMessage();
                String error = this.htmlEncoder.encode(rawMessage);
                this.addObjectError(errors, "embedded.crowd.connection.test.failed", new Serializable[]{error});
                if (rawMessage != null && rawMessage.toLowerCase().contains("error code")) {
                    model.put("addErrorCodeLink", true);
                }
            }
        } else {
            this.addObjectError(errors, "embedded.crowd.validation.submission.mode.missing", new Serializable[0]);
        }
        return this.showForm(request, response, errors, model);
    }

    private Directory createDirectoryFromCommand(Object command) {
        Directory newDirectory = this.createDirectory(command);
        if (command instanceof ConfigurationWithPassword) {
            ConfigurationWithPassword configurationWithPassword = (ConfigurationWithPassword)command;
            return this.passwordRestoreUtil.restoreOldPasswordIfNewIsEmpty(configurationWithPassword, newDirectory);
        }
        return newDirectory;
    }

    protected abstract Directory createDirectory(Object var1);

    protected Directory createUpdatedDirectory(Directory oldDirectory, Directory newDirectory) {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)newDirectory);
        builder.setCreatedDate(oldDirectory.getCreatedDate());
        HashMap updatedAttributes = new HashMap(oldDirectory.getAttributes());
        updatedAttributes.putAll(newDirectory.getAttributes());
        builder.setAttributes(updatedAttributes);
        return builder.toDirectory();
    }

    private boolean directoryNameInUse(String directoryName) {
        EntityQuery directoryQuery = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.NAME).exactlyMatching((Object)directoryName)).returningAtMost(-1);
        return !this.directoryManager.searchDirectories(directoryQuery).isEmpty();
    }

    private Directory saveDirectory(final Directory directory) throws DirectoryInstantiationException {
        if (directory.getId() <= 0L) {
            if (StringUtils.isEmpty((String)directory.getName())) {
                throw new DirectoryInstantiationException(this.i18nResolver.getText("embedded.crowd.validation.directory.name.required", new Serializable[]{directory.getName()}));
            }
            if (this.directoryNameInUse(directory.getName())) {
                throw new DirectoryInstantiationException(this.i18nResolver.getText("embedded.crowd.validation.directory.name.conflict", new Serializable[]{directory.getName()}));
            }
            return (Directory)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Directory>(){

                public Directory doInTransaction() {
                    log.info("User directory created: [ {} ], type: [ {} ]", (Object)directory.getName(), (Object)directory.getType());
                    Directory newDirectory = ConfigurationController.this.crowdDirectoryService.addDirectory(directory);
                    ConfigurationController.this.postprocessDirectory(newDirectory);
                    return newDirectory;
                }
            });
        }
        return (Directory)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Directory>(){

            public Directory doInTransaction() {
                log.info("User directory updated: [ {} ], type: [ {} ]", (Object)directory.getName(), (Object)directory.getType());
                Directory oldDirectory = ConfigurationController.this.crowdDirectoryService.findDirectoryById(directory.getId().longValue());
                Directory updatedDirectory = ConfigurationController.this.createUpdatedDirectory(oldDirectory, directory);
                Directory newDirectory = ConfigurationController.this.crowdDirectoryService.updateDirectory(updatedDirectory);
                ConfigurationController.this.postprocessDirectory(newDirectory);
                return newDirectory;
            }
        });
    }

    protected String getDefaultLdapAutoAddGroups() {
        StringBuilder defaultGroups = new StringBuilder();
        for (DefaultGroupsModuleDescriptor defaultGroupDescriptor : this.pluginAccessor.getEnabledModuleDescriptorsByClass(DefaultGroupsModuleDescriptor.class)) {
            Iterator i$ = defaultGroupDescriptor.getModule().iterator();
            while (i$.hasNext()) {
                String groupName = (String)i$.next();
                if (defaultGroups.length() > 0) {
                    defaultGroups.append(", ");
                }
                defaultGroups.append(groupName);
            }
        }
        if (defaultGroups.length() == 0) {
            log.warn("No default auto add group is defined.");
        }
        return defaultGroups.toString();
    }

    protected void postprocessDirectory(Directory directory) {
        String groups = (String)directory.getAttributes().get("autoAddGroups");
        if (StringUtils.isNotBlank((String)groups)) {
            for (String groupName : StringUtils.split((String)groups, (String)"|")) {
                try {
                    this.ensureGroupExistsInDirectory(directory.getId(), groupName);
                }
                catch (CrowdException e) {
                    log.warn("Failed to create group '" + groupName + "' for auto-add groups of '" + directory.getName() + "'", (Throwable)e);
                }
                catch (ApplicationPermissionException e) {
                    log.warn("Failed to create group '" + groupName + "' for auto-add groups of '" + directory.getName() + "'", (Throwable)e);
                }
            }
        }
    }

    private void ensureGroupExistsInDirectory(long directoryId, String groupName) throws GroupNotFoundException, ApplicationPermissionException, com.atlassian.crowd.exception.OperationFailedException, DirectoryNotFoundException {
        try {
            this.directoryManager.findGroupByName(directoryId, groupName);
        }
        catch (GroupNotFoundException ex) {
            try {
                this.directoryManager.addGroup(directoryId, new GroupTemplate(groupName, directoryId));
            }
            catch (DirectoryPermissionException ex2) {
                throw new ApplicationPermissionException("Group '" + groupName + "' does not exist in the directory of the user and cannot be added.");
            }
            catch (InvalidGroupException e) {
                throw new com.atlassian.crowd.exception.OperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void addObjectError(BindException errors, String message, Serializable ... arguments) {
        errors.addError(new ObjectError("configuration", this.i18nResolver.getText(message, arguments)));
    }

    public final void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    public final void setDirectoryMapper(DirectoryMapper directoryMapper) {
        this.directoryMapper = directoryMapper;
    }

    public final void setDirectoryContextHelper(DirectoryContextHelper directoryContextHelper) {
        this.directoryContextHelper = directoryContextHelper;
    }

    public final void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public final void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    protected I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    public void setHtmlEncoder(HtmlEncoder htmlEncoder) {
        this.htmlEncoder = htmlEncoder;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setPasswordRestoreUtil(PasswordRestoreUtil passwordRestoreUtil) {
        this.passwordRestoreUtil = passwordRestoreUtil;
    }
}

