/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.mockito.Matchers;

public class EntityQueryMatcher<T>
extends TypeSafeMatcher<EntityQuery<T>> {
    private EntityDescriptor entityDescriptor;
    private Class<T> returnType;
    private List<String> entityNames;

    public EntityQueryMatcher(EntityDescriptor entityDescriptor, Class<T> returnType, String ... entityNames) {
        this.entityDescriptor = entityDescriptor;
        this.returnType = returnType;
        this.entityNames = Arrays.asList(entityNames);
    }

    protected boolean matchesSafely(EntityQuery entityQuery) {
        boolean entityDescriptorMatches = entityQuery.getEntityDescriptor().equals((Object)this.entityDescriptor);
        boolean returnTypeMatches = entityQuery.getReturnType().equals(this.returnType);
        SearchRestriction searchRestriction = entityQuery.getSearchRestriction();
        boolean searchRestrictionMatches = this.isSearchRestrictionMatching(searchRestriction);
        return entityDescriptorMatches && searchRestrictionMatches && returnTypeMatches;
    }

    public void describeTo(Description description) {
        description.appendText("Expected a query with entity descriptor ").appendValue((Object)this.entityDescriptor).appendText(" and return type ").appendValue(this.returnType).appendText(" and restrictions for entities ").appendValue(this.entityNames);
    }

    public void describeMismatchSafely(EntityQuery entityQuery, Description description) {
        description.appendText("was a query with entity descriptor ").appendValue((Object)entityQuery.getEntityDescriptor()).appendText(" and return type ").appendValue((Object)entityQuery.getReturnType()).appendText(" and restriction ").appendValue((Object)entityQuery.getSearchRestriction());
    }

    private boolean isSearchRestrictionMatching(SearchRestriction searchRestriction) {
        if (this.entityNames.size() == 0) {
            return searchRestriction instanceof NullRestriction;
        }
        if (this.entityNames.size() == 1) {
            if (searchRestriction instanceof PropertyRestriction) {
                PropertyRestriction propertyRestriction = (PropertyRestriction)searchRestriction;
                return propertyRestriction.getProperty().equals(UserTermKeys.USERNAME) && propertyRestriction.getValue().equals(this.entityNames.get(0));
            }
            return searchRestriction instanceof BooleanRestriction && this.subrestrictionsMatch((BooleanRestriction)searchRestriction);
        }
        if (searchRestriction instanceof BooleanRestriction) {
            for (SearchRestriction restriction : ((BooleanRestriction)searchRestriction).getRestrictions()) {
                if (restriction instanceof PropertyRestriction) continue;
                return false;
            }
            return this.subrestrictionsMatch((BooleanRestriction)searchRestriction);
        }
        return false;
    }

    private boolean subrestrictionsMatch(BooleanRestriction searchRestriction) {
        Set restrictionNames = searchRestriction.getRestrictions().stream().map(restriction -> ((PropertyRestriction)restriction).getValue()).collect(Collectors.toSet());
        return restrictionNames.equals(new HashSet<String>(this.entityNames));
    }

    public static <T> EntityQuery<T> entityQueryMatches(EntityDescriptor entityDescriptor, Class<T> returnType, String ... entityNames) {
        return (EntityQuery)Matchers.argThat(new EntityQueryMatcher<T>(entityDescriptor, returnType, entityNames));
    }
}

