/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import java.util.Objects;
import org.apache.commons.lang3.builder.Diff;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class DiffMatcher
extends TypeSafeMatcher<Diff> {
    private final String fieldName;
    private final Matcher<?> oldValue;
    private final Matcher<?> newValue;

    public DiffMatcher(String fieldName, Matcher<?> oldValue, Matcher<?> newValue) {
        this.fieldName = fieldName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    protected boolean matchesSafely(Diff item) {
        return Objects.equals(this.fieldName, item.getFieldName()) && this.oldValue.matches(item.getLeft()) && this.newValue.matches(item.getRight());
    }

    public void describeTo(Description description) {
        description.appendText("a diff for field: ").appendValue((Object)this.fieldName).appendText(", old value: ").appendValue(this.oldValue).appendText(", new value: ").appendValue(this.newValue);
    }

    protected void describeMismatchSafely(Diff item, Description mismatchDescription) {
        mismatchDescription.appendText("was a diff for field: ").appendValue((Object)item.getFieldName()).appendText(", old value: ").appendValue(item.getLeft()).appendText(", new value: ").appendValue(item.getRight());
    }

    public static DiffMatcher diff(String fieldName, Matcher<?> oldValue, Matcher<?> newValue) {
        return new DiffMatcher(fieldName, oldValue, newValue);
    }
}

