/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.audit.AuditLogEntry;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class AuditLogEntryMatcher
extends TypeSafeMatcher<AuditLogEntry> {
    private final String propertyName;
    private final String oldValue;
    private final String newValue;

    private AuditLogEntryMatcher(String propertyName, String oldValue, String newValue) {
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    protected boolean matchesSafely(AuditLogEntry item) {
        return Objects.equals(item.getPropertyName(), this.propertyName) && Objects.equals(item.getOldValue(), this.oldValue) && Objects.equals(item.getNewValue(), this.newValue);
    }

    public void describeTo(Description description) {
        description.appendText("a changeset entry with property: ").appendValue((Object)this.propertyName).appendText(", old value: ").appendValue((Object)this.oldValue).appendText(", new value: ").appendValue((Object)this.newValue);
    }

    protected void describeMismatchSafely(AuditLogEntry item, Description mismatchDescription) {
        mismatchDescription.appendText("was property: ").appendValue((Object)item.getPropertyName()).appendText(", old value: ").appendValue((Object)item.getOldValue()).appendText(", new value: ").appendValue((Object)item.getNewValue());
    }

    public static AuditLogEntryMatcher entry(String propertyName, String oldValue, String newValue) {
        return new AuditLogEntryMatcher(propertyName, oldValue, newValue);
    }

    public static AuditLogEntryMatcher entry(AuditLogEntry entry) {
        return new AuditLogEntryMatcher(entry.getPropertyName(), entry.getOldValue(), entry.getNewValue());
    }
}

