/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.audit.AuditLogEntity;
import com.atlassian.crowd.audit.AuditLogEntityType;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class AuditLogEntityMatcher
extends TypeSafeMatcher<AuditLogEntity> {
    private final AuditLogEntityType entityType;
    private final Long entityId;
    private final String entityName;
    private final boolean primary;

    private AuditLogEntityMatcher(AuditLogEntityType entityType, Long entityId, String entityName, boolean primary) {
        this.entityType = entityType;
        this.entityId = entityId;
        this.entityName = entityName;
        this.primary = primary;
    }

    protected boolean matchesSafely(AuditLogEntity item) {
        return Objects.equals(item.getEntityType(), this.entityType) && Objects.equals(item.getEntityId(), this.entityId) && Objects.equals(item.getEntityName(), this.entityName) && Objects.equals(item.isPrimary(), this.primary);
    }

    public void describeTo(Description description) {
        description.appendText("an entity with type: ").appendValue((Object)this.entityType).appendText(", id: ").appendValue((Object)this.entityId).appendText(", name: ").appendValue((Object)this.entityName).appendText(" and marked as ").appendText(this.primary ? "primary" : "secondary");
    }

    public static AuditLogEntityMatcher entity(AuditLogEntityType entityType, Long entityId, String entityName, boolean primary) {
        return new AuditLogEntityMatcher(entityType, entityId, entityName, primary);
    }
}

