/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.DirectoryMembershipsIterable;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierMap;
import com.atlassian.crowd.embedded.impl.IdentifierSet;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.avatar.AvatarReference;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BoundedCount;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockSimpleRemoteDirectory
implements RemoteDirectory {
    protected Map<String, User> userMap = new IdentifierMap();
    protected Map<String, User> userByExternalIdMap = new HashMap<String, User>();
    protected Map<String, Map<String, Set<String>>> userAttributesMap = new IdentifierMap();
    protected Map<String, Group> groupMap = new IdentifierMap();
    protected Map<String, Group> roleMap = new IdentifierMap();
    protected Map<String, String> attributeMap = new HashMap<String, String>();
    protected Map<String, Set<String>> userMemberships = new IdentifierMap();
    protected long directoryId;
    protected boolean supportsInactiveAccounts = true;

    public MockSimpleRemoteDirectory() {
        this.directoryId = 1L;
    }

    public MockSimpleRemoteDirectory(long directoryId) {
        this.directoryId = directoryId;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    public String getDescriptiveName() {
        return "MockRemoteDirectory";
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setAttribute(String key, String value) {
        this.attributeMap.put(key, value);
    }

    public User findUserByName(String name) throws UserNotFoundException {
        User user = this.userMap.get(name);
        if (user == null) {
            throw new UserNotFoundException(name);
        }
        return user;
    }

    public User findUserByNameOrNull(String name) {
        return this.userMap.get(name);
    }

    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        UserTemplateWithAttributes user = UserTemplateWithAttributes.toUserWithNoAttributes((User)this.findUserByName(name));
        Map<String, Set<String>> attributes = this.userAttributesMap.get(name);
        if (attributes != null) {
            for (Map.Entry<String, Set<String>> entry : attributes.entrySet()) {
                user.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        return user;
    }

    public User findUserByExternalId(String externalId) throws UserNotFoundException {
        User user = this.userByExternalIdMap.get(externalId);
        if (user == null) {
            throw new UserNotFoundException(externalId);
        }
        return user;
    }

    public User authenticate(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        if (credential == null) {
            throw InvalidAuthenticationException.newInstanceWithName((String)name);
        }
        if (credential.isEncryptedCredential()) {
            throw InvalidAuthenticationException.newInstanceWithName((String)name);
        }
        return this.findUserByName(name);
    }

    public User addUser(UserTemplate user, PasswordCredential credential) throws UserAlreadyExistsException {
        return this.addUser(UserTemplateWithAttributes.toUserWithNoAttributes((User)user), credential);
    }

    public UserWithAttributes addUser(UserTemplateWithAttributes user, PasswordCredential credential) throws UserAlreadyExistsException {
        if (!this.userMap.containsKey(user.getName())) {
            return this.putUser(user);
        }
        throw new UserAlreadyExistsException(this.directoryId, user.getName());
    }

    protected Directory getDirectory() {
        return new DirectoryImpl(){

            public Long getId() {
                return MockSimpleRemoteDirectory.this.directoryId;
            }
        };
    }

    public User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        if (this.userMap.containsKey(user.getName())) {
            return this.putUser(UserTemplateWithAttributes.toUserWithNoAttributes((User)user));
        }
        throw new UserNotFoundException(user.getName());
    }

    protected User copyUser(UserTemplate template) {
        return new UserTemplate((User)template);
    }

    protected UserWithAttributes deriveUserWithAttributes(User user, UserTemplate template) {
        return UserTemplateWithAttributes.toUserWithNoAttributes((User)user);
    }

    protected UserWithAttributes putUser(UserTemplateWithAttributes user) {
        UserTemplate userTemplate = new UserTemplate((User)user);
        if (!this.supportsInactiveAccounts()) {
            userTemplate.setActive(true);
        }
        User newUser = this.copyUser(userTemplate);
        this.userMap.put(user.getName(), newUser);
        this.userAttributesMap.put(user.getName(), Maps.newHashMap((Map)user.getAttributes()));
        if (user.getExternalId() != null) {
            this.userByExternalIdMap.put(user.getExternalId(), (User)user);
        }
        return this.deriveUserWithAttributes(newUser, (UserTemplate)user);
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        return this.rename(this.findUserByName(oldName), newName);
    }

    protected User rename(User oldUser, String newName) throws UserNotFoundException, UserAlreadyExistsException {
        UserTemplate newUser = new UserTemplate(oldUser);
        newUser.setName(newName);
        this.removeUser(oldUser.getName());
        return this.addUser(newUser, PasswordCredential.NONE);
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        if (!this.userMap.containsKey(username)) {
            throw new UserNotFoundException(username);
        }
        Map<String, Set<String>> cachedAttributes = this.userAttributesMap.get(username);
        if (cachedAttributes == null) {
            cachedAttributes = new HashMap<String, Set<String>>();
            this.userAttributesMap.put(username, cachedAttributes);
        }
        cachedAttributes.putAll(attributes);
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        this.userAttributesMap.get(username).remove(attributeName);
    }

    public void removeUser(String name) throws UserNotFoundException {
        this.userMap.remove(name);
        this.userAttributesMap.remove(name);
        for (Set<String> users : this.userMemberships.values()) {
            users.remove(name);
        }
    }

    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        if (query.getEntityDescriptor().getEntityType() == Entity.USER) {
            return new ArrayList<User>(this.userMap.values());
        }
        if (query.getEntityDescriptor().getEntityType() == Entity.GROUP) {
            ArrayList<Group> result = new ArrayList<Group>();
            result.addAll(this.groupMap.values());
            result.addAll(this.roleMap.values());
            return result;
        }
        return Collections.emptyList();
    }

    public Group findGroupByName(String name) throws GroupNotFoundException {
        Group group = this.groupMap.get(name);
        if (group == null && (group = this.roleMap.get(name)) == null) {
            throw new GroupNotFoundException(name);
        }
        return group;
    }

    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        switch (group.getType()) {
            case GROUP: {
                this.groupMap.put(group.getName(), (Group)new GroupTemplate((Group)group));
                return group;
            }
            case LEGACY_ROLE: {
                this.roleMap.put(group.getName(), (Group)new GroupTemplate((Group)group));
                return group;
            }
        }
        throw new IllegalArgumentException("Unknown Group Type");
    }

    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, OperationFailedException {
        if (this.groupMap.containsKey(group.getName()) || this.roleMap.containsKey(group.getName())) {
            return this.addGroup(group);
        }
        throw new GroupNotFoundException(group.getName());
    }

    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException {
        this.groupMap.remove(name);
        this.roleMap.remove(name);
    }

    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        switch (query.getEntityDescriptor().getGroupType()) {
            case GROUP: {
                return new ArrayList<Group>(this.groupMap.values());
            }
            case LEGACY_ROLE: {
                return new ArrayList<Group>(this.roleMap.values());
            }
        }
        throw new IllegalArgumentException("Unknown Group Type");
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        Set<String> members = this.userMemberships.get(groupName);
        return members != null && members.contains(username);
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public BoundedCount countDirectMembersOfGroup(String groupName, int querySizeHint) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, OperationFailedException, MembershipAlreadyExistsException {
        if (!this.userMemberships.containsKey(groupName)) {
            IdentifierSet users = new IdentifierSet();
            this.userMemberships.put(groupName, (Set<String>)users);
        }
        if (this.userMemberships.get(groupName).contains(username)) {
            throw new MembershipAlreadyExistsException(this.getDirectoryId(), username, groupName);
        }
        this.userMemberships.get(groupName).add(username);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        return Collections.emptyList();
    }

    public void testConnection() throws OperationFailedException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void setSupportsInactiveAccounts(boolean supportsInactiveAccounts) {
        this.supportsInactiveAccounts = supportsInactiveAccounts;
    }

    public boolean supportsInactiveAccounts() {
        return this.supportsInactiveAccounts;
    }

    public boolean supportsNestedGroups() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean supportsPasswordExpiration() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean supportsSettingEncryptedCredential() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean isRolesDisabled() {
        return false;
    }

    public Set<String> getValues(String key) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public String getValue(String key) {
        return this.attributeMap.get(key);
    }

    public Set<String> getKeys() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Group getGroup(String name) {
        return this.groupMap.get(name);
    }

    public Group getRole(String name) {
        return this.roleMap.get(name);
    }

    public RemoteDirectory getAuthoritativeDirectory() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public Iterable<Membership> getMemberships() throws OperationFailedException {
        return new DirectoryMembershipsIterable((RemoteDirectory)this);
    }

    public void expireAllPasswords() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public AvatarReference getUserAvatarByName(String username, int sizeHint) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }
}

