/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.matchers;

import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.test.matchers.UserMatcher;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class UserRenamedEventMatcher
extends TypeSafeMatcher<UserRenamedEvent> {
    private final long directoryId;
    private final UserMatcher<User> userMatcher;
    private final String oldUsername;

    public UserRenamedEventMatcher(long directoryId, User user, String oldUsername) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)oldUsername);
        this.directoryId = directoryId;
        this.userMatcher = UserMatcher.userNamed(user.getName()).withExternalIdOf(user.getExternalId()).withActive(user.isActive());
        this.oldUsername = oldUsername;
    }

    public void describeTo(Description description) {
        description.appendText("UserRenamedEvent");
        description.appendText(" with directory id ").appendText(Long.toString(this.directoryId));
        description.appendText(" and ");
        this.userMatcher.describeTo(description);
        description.appendText(" and ");
        description.appendText("with old username ").appendText(this.oldUsername);
    }

    protected boolean matchesSafely(@Nonnull UserRenamedEvent item) {
        return this.directoryId == item.getDirectory().getId() && this.userMatcher.matchesSafely(item.getUser()) && this.oldUsername.equals(item.getOldUsername());
    }
}

