/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.math.NumberUtils;

public class UpgradeTask424
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private final Collection<String> errors = new ArrayList<String>();
    public static final String DEFAULT_SYNC_INTERVAL = "3600";
    private static final int MINIMUM_SYNC_INTERVAL = 600;
    public static final String ATTRIBUTE_KEY_USE_CACHING = "useCaching";
    public static final String ATTRIBUTE_KEY_USE_MONITORING = "useMonitoring";
    public static final String ATTRIBUTE_KEY_CACHE_CLASS = "cacheClass";
    public static final String ATTRIBUTE_KEY_CACHE_MAX_ELEMENTS_IN_MEMORY = "cacheMaxElements";
    public static final String ATTRIBUTE_KEY_POLLING_INTERVAL = "pollingInterval";

    @Override
    public String getBuildNumber() {
        return "424";
    }

    @Override
    public String getShortDescription() {
        return "All LDAP directories now have caching enabled. Removing unnecessary attributes and adding directory.cache.synchronise.interval";
    }

    @Override
    public void doUpgrade() throws DirectoryNotFoundException {
        for (Directory directory : this.findAllConnectorAndDelegatingDirectories()) {
            DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
            if (directoryToUpdate.getType().equals((Object)DirectoryType.CONNECTOR)) {
                this.updateCacheSyncIntervalAttribute(directoryToUpdate);
            }
            this.removeOldAttributes(directoryToUpdate);
            this.directoryManager.updateDirectory((Directory)directoryToUpdate);
        }
    }

    private void updateCacheSyncIntervalAttribute(DirectoryImpl directoryToUpdate) {
        int syncInterval = NumberUtils.toInt((String)directoryToUpdate.getValue(ATTRIBUTE_KEY_POLLING_INTERVAL));
        if (syncInterval < 600) {
            directoryToUpdate.setAttribute("directory.cache.synchronise.interval", DEFAULT_SYNC_INTERVAL);
        } else {
            directoryToUpdate.setAttribute("directory.cache.synchronise.interval", String.valueOf(syncInterval));
        }
    }

    private void removeOldAttributes(DirectoryImpl directoryToUpdate) {
        directoryToUpdate.removeAttribute(ATTRIBUTE_KEY_USE_CACHING);
        directoryToUpdate.removeAttribute(ATTRIBUTE_KEY_USE_MONITORING);
        directoryToUpdate.removeAttribute(ATTRIBUTE_KEY_CACHE_CLASS);
        directoryToUpdate.removeAttribute(ATTRIBUTE_KEY_CACHE_MAX_ELEMENTS_IN_MEMORY);
        directoryToUpdate.removeAttribute(ATTRIBUTE_KEY_POLLING_INTERVAL);
    }

    private List<Directory> findAllConnectorAndDelegatingDirectories() {
        return this.directoryManager.searchDirectories(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CONNECTOR), Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.DELEGATING)})).returningAtMost(-1));
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

