/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.descriptors;

import com.atlassian.crowd.event.XWorkStateChangeEvent;
import com.atlassian.crowd.plugin.descriptors.webwork.PluginAwareActionConfig;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationManager;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.ConfigurationUtil;
import com.opensymphony.xwork.config.ExternalReferenceResolver;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ExternalReference;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import com.opensymphony.xwork.config.providers.XmlConfigurationProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XWorkModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware,
ConfigurationProvider {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List packages;
    private Element element;
    private boolean enabled;
    private final EventPublisher eventPublisher;

    public XWorkModuleDescriptor(ModuleFactory moduleFactory, EventPublisher eventPublisher) {
        super(moduleFactory);
        this.eventPublisher = eventPublisher;
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        try {
            this.enabled = false;
            this.element = element;
            ConfigurationManager.getConfigurationProviders();
            ConfigurationManager.addConfigurationProvider((ConfigurationProvider)this);
        }
        catch (Throwable t) {
            this.log.error("Failed to add configuration provider", t);
        }
    }

    public void enabled() {
        super.enabled();
        if (!this.enabled) {
            this.enabled = true;
            this.eventPublisher.publish((Object)new XWorkStateChangeEvent((Object)this));
        }
    }

    public void disabled() {
        if (this.enabled) {
            this.enabled = false;
            this.eventPublisher.publish((Object)new XWorkStateChangeEvent((Object)this));
        }
        super.disabled();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private Configuration getXWorkConfiguration() {
        return ConfigurationManager.getConfiguration();
    }

    private List getPackages(Element element, Configuration configuration) {
        ArrayList<PackageConfig> configuredPackages = new ArrayList<PackageConfig>();
        Iterator it = element.elementIterator("package");
        while (it.hasNext()) {
            Element packageElement = (Element)it.next();
            PackageConfig newPackage = this.buildPackageContext(packageElement, configuration);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Loading " + newPackage);
            }
            try {
                this.addResultTypes(newPackage, packageElement);
                this.loadInterceptors(newPackage, packageElement);
                this.loadDefaultInterceptorRef(newPackage, packageElement);
                this.loadGlobalResults(newPackage, packageElement);
                Iterator actionIt = packageElement.elementIterator("action");
                while (actionIt.hasNext()) {
                    Element actionElement = (Element)actionIt.next();
                    this.addAction(actionElement, newPackage);
                }
                configuredPackages.add(newPackage);
            }
            catch (ConfigurationException e) {
                this.log.error("Could not add package: " + newPackage + " because: " + (Object)((Object)e), (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                this.log.error("Could not load action: " + e.getMessage(), (Throwable)e);
            }
        }
        return configuredPackages;
    }

    protected void loadInterceptors(PackageConfig context, Element element) throws ConfigurationException {
        List interceptorList = element.elements("interceptor");
        for (int i = 0; i < interceptorList.size(); ++i) {
            InterceptorConfig config;
            Element interceptorElement = (Element)interceptorList.get(i);
            String name = interceptorElement.attributeValue("name");
            String className = interceptorElement.attributeValue("class");
            HashMap params = XWorkModuleDescriptor.getParams(interceptorElement);
            try {
                config = new InterceptorConfig(name, className, (Map)params);
                ObjectFactory.getObjectFactory().buildInterceptor(config, new HashMap());
                context.addInterceptorConfig(config);
            }
            catch (ConfigurationException e) {
                String s = "Unable to load class " + className + " for interceptor name " + name + ". This interceptor will not be available.";
                this.log.error(s);
                throw e;
            }
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    protected void loadDefaultInterceptorRef(PackageConfig packageContext, Element element) {
        List resultTypeList = element.elements("default-interceptor-ref");
        if (resultTypeList.size() > 0) {
            Element defaultRefElement = (Element)resultTypeList.get(0);
            packageContext.setDefaultInterceptorRef(defaultRefElement.attributeValue("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig packageContext, Element packageElement) throws ClassNotFoundException {
        List globalResultList = packageElement.elements("global-results");
        if (globalResultList.size() > 0) {
            Element globalResultElement = (Element)globalResultList.get(0);
            Map results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected Map buildResults(Element element, PackageConfig packageContext) throws ClassNotFoundException {
        List resultEls = element.elements("result");
        HashMap<String, ResultConfig> results = new HashMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.size(); ++i) {
            HashMap<String, String> params;
            ResultTypeConfig config;
            Element resultElement = (Element)resultEls.get(i);
            if (!resultElement.getParent().equals(element)) continue;
            String resultName = resultElement.attributeValue("name");
            String resultType = resultElement.attributeValue("type");
            if (!TextUtils.stringSet((String)resultType)) {
                resultType = packageContext.getFullDefaultResultType();
            }
            if ((config = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(resultType)) == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'");
            }
            Class resultClass = ClassLoaderUtil.loadClass((String)config.getClazz(), XWorkModuleDescriptor.class);
            if (resultClass == null) {
                this.log.error("Result type '" + resultType + "' is invalid. Modify your xwork.xml file.");
            }
            if ((params = XWorkModuleDescriptor.getParams(resultElement)).size() == 0 && resultElement.elements().size() == 0 && resultElement.getText() != null) {
                params = new HashMap<String, String>();
                try {
                    String paramName = (String)resultClass.getField("DEFAULT_PARAM").get(null);
                    params.put(paramName, resultElement.getText());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ResultConfig resultConfig = new ResultConfig(resultName, resultClass.getCanonicalName(), (Map)params);
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    private List lookupInterceptorReference(PackageConfig context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.attributeValue("name");
        HashMap refParams = XWorkModuleDescriptor.getParams(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference((PackageConfig)context, (String)refName, (Map)refParams);
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig context) throws ConfigurationException {
        String name = element.attributeValue("name");
        InterceptorStackConfig config = new InterceptorStackConfig(name);
        List interceptorRefList = element.elements("interceptor-ref");
        for (int j = 0; j < interceptorRefList.size(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.get(j);
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors(interceptors);
        }
        return config;
    }

    protected void loadInterceptorStacks(Element element, PackageConfig context) throws ConfigurationException {
        List interceptorStackList = element.elements("interceptor-stack");
        for (int i = 0; i < interceptorStackList.size(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.get(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void addAction(Element actionElement, PackageConfig packageContext) throws ConfigurationException, ClassNotFoundException {
        Map results;
        String name = actionElement.attributeValue("name");
        String className = actionElement.attributeValue("class");
        String methodName = actionElement.attributeValue("method");
        methodName = methodName == null || methodName.trim().length() <= 0 ? null : methodName.trim();
        try {
            PluginAwareActionConfig actionConfig = new PluginAwareActionConfig(null, className, null, null, null);
            actionConfig.setPlugin(this.plugin);
            ObjectFactory.getObjectFactory().buildAction(name, packageContext.getNamespace(), (ActionConfig)actionConfig, null);
        }
        catch (Exception e) {
            this.log.error("Action class [" + className + "] not found, skipping action [" + name + "]", (Throwable)e);
            throw new RuntimeException(e);
        }
        HashMap actionParams = XWorkModuleDescriptor.getParams(actionElement);
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), (Throwable)e);
        }
        List interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List externalrefs = this.buildExternalRefs(actionElement, packageContext);
        PluginAwareActionConfig actionConfig = new PluginAwareActionConfig(methodName, className, actionParams, results, interceptorList, externalrefs, packageContext.getName());
        actionConfig.setPlugin(this.plugin);
        packageContext.addActionConfig(name, (ActionConfig)actionConfig);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Loaded " + (TextUtils.stringSet((String)packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : "") + name + " in '" + packageContext.getName() + "' package:" + (Object)((Object)actionConfig));
        }
    }

    protected List buildExternalRefs(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList<ExternalReference> refs = new ArrayList<ExternalReference>();
        List externalRefList = element.elements("external-ref");
        String refValue = null;
        for (int i = 0; i < externalRefList.size(); ++i) {
            String requiredTemp;
            Element refElement = (Element)externalRefList.get(i);
            if (!refElement.getParent().equals(element)) continue;
            String refName = refElement.attributeValue("name");
            if (refElement.elements().size() > 0) {
                refValue = ((Element)refElement.elements().get(0)).getText();
            }
            boolean required = (requiredTemp = refElement.attributeValue("required")) == null || "".equals(requiredTemp) ? true : Boolean.valueOf(requiredTemp);
            refs.add(new ExternalReference(refName, refValue, required));
        }
        return refs;
    }

    protected void addResultTypes(PackageConfig packageContext, Element element) {
        List resultTypeList = element.elements("result-type");
        for (int i = 0; i < resultTypeList.size(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.get(i);
            String name = resultTypeElement.attributeValue("name");
            String className = resultTypeElement.attributeValue("class");
            String def = resultTypeElement.attributeValue("default");
            try {
                Class clazz = ClassLoaderUtil.loadClass((String)className, XmlConfigurationProvider.class);
                ResultTypeConfig resultType = new ResultTypeConfig(name, clazz.getCanonicalName(), null);
                packageContext.addResultTypeConfig(resultType);
                if (!"true".equals(def)) continue;
                packageContext.setDefaultResultType(name);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.log.error("Result class [" + className + "] doesn't exist, ignoring");
            }
        }
    }

    public Object getModule() {
        return null;
    }

    protected PackageConfig buildPackageContext(Element packageElement, Configuration configuration) {
        List parents;
        String name = TextUtils.noNull((String)packageElement.attributeValue("name"));
        String namespace = TextUtils.noNull((String)packageElement.attributeValue("namespace"));
        String parent = packageElement.attributeValue("extends");
        String abstractVal = packageElement.attributeValue("abstract");
        boolean isAbstract = Boolean.valueOf(abstractVal);
        ExternalReferenceResolver erResolver = null;
        String externalReferenceResolver = TextUtils.noNull((String)packageElement.attributeValue("externalReferenceResolver"));
        if (!"".equals(externalReferenceResolver)) {
            try {
                Class erResolverClazz = ClassLoaderUtil.loadClass((String)externalReferenceResolver, ExternalReferenceResolver.class);
                erResolver = (ExternalReferenceResolver)erResolverClazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "Could not find External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                this.log.error(msg);
                throw new ConfigurationException(msg, (Throwable)e);
            }
            catch (Exception e) {
                String msg = "Could not create External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                this.log.error(msg);
                throw new ConfigurationException(msg, (Throwable)e);
            }
        }
        PackageConfig pkgConfig = null;
        if (!TextUtils.stringSet((String)TextUtils.noNull((String)parent))) {
            pkgConfig = new PackageConfig(name, namespace, isAbstract, erResolver);
        }
        if ((parents = ConfigurationUtil.buildParentsFromString((Configuration)configuration, (String)parent)).size() <= 0) {
            this.log.error("Unable to find parent packages " + parent);
            pkgConfig = new PackageConfig(name, namespace, isAbstract, erResolver);
        } else {
            pkgConfig = new PackageConfig(name, namespace, isAbstract, erResolver, parents);
        }
        return pkgConfig;
    }

    protected List buildInterceptorList(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList interceptorList = new ArrayList();
        List interceptorRefList = element.elements("interceptor-ref");
        for (int i = 0; i < interceptorRefList.size(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.get(i);
            if (!interceptorRefElement.getParent().equals(element)) continue;
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    public static HashMap getParams(Element paramsElement) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (paramsElement == null) {
            return params;
        }
        List childNodes = paramsElement.elements();
        for (int i = 0; i < childNodes.size(); ++i) {
            Element childNode = (Element)childNodes.get(i);
            if (childNode.getNodeType() != 1 || !"param".equals(childNode.getName())) continue;
            String paramName = childNode.attributeValue("name");
            if (childNode.getText() == null) continue;
            String paramValue = childNode.getText();
            params.put(paramName, paramValue);
        }
        return params;
    }

    public void destroy() {
    }

    public void init(Configuration configuration) throws ConfigurationException {
        if (this.enabled) {
            try {
                for (PackageConfig packageConfig : this.getPackages(configuration)) {
                    configuration.addPackageConfig(packageConfig.getName(), packageConfig);
                }
            }
            catch (RuntimeException e) {
                this.enabled = false;
                throw e;
            }
        }
    }

    public boolean needsReload() {
        return this.enabled;
    }

    private List getPackages(Configuration configuration) {
        this.packages = this.getPackages(this.element, configuration);
        return this.packages;
    }
}

