/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.license;

import com.atlassian.crowd.event.LicenseResourceLimitEvent;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManagerException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.crowd.CrowdLicense;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.scheduling.quartz.QuartzJobBean;

public class LicenseResourceJob
extends QuartzJobBean
implements StatefulJob {
    private static final Logger log = LoggerFactory.getLogger(LicenseResourceJob.class);
    private PropertyManager propertyManager;
    private CrowdLicenseManager crowdLicenseManager;
    private EventPublisher eventPublisher;

    protected void executeInternal(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        CrowdLicense license = this.crowdLicenseManager.getLicense();
        if (license != null && !license.isUnlimitedNumberOfUsers()) {
            int currentResourceCount = this.getCurrentResourceTotal();
            int oldResourceTotal = this.propertyManager.getCurrentLicenseResourceTotal();
            log.debug("Current number of resources: " + currentResourceCount + ". Old resource Count: " + oldResourceTotal);
            if (currentResourceCount > oldResourceTotal && this.crowdLicenseManager.isResourceTotalOverLimit(90.0f, currentResourceCount)) {
                this.eventPublisher.publish((Object)new LicenseResourceLimitEvent((Object)this, Integer.valueOf(currentResourceCount)));
            }
            this.updateCurrentResourceTotal(currentResourceCount);
        }
    }

    private void updateCurrentResourceTotal(int currentResourceCount) throws JobExecutionException {
        try {
            this.propertyManager.setCurrentLicenseResourceTotal(currentResourceCount);
        }
        catch (DataAccessException e) {
            log.error("Failed to update license resource totals", (Throwable)e);
            throw new JobExecutionException("Failed to update license resource totals", (Exception)((Object)e), false);
        }
    }

    private int getCurrentResourceTotal() throws JobExecutionException {
        try {
            return this.crowdLicenseManager.getCurrentResourceUsageTotal();
        }
        catch (CrowdLicenseManagerException e) {
            log.error("Failed to get current resource usage total", (Throwable)e);
            throw new JobExecutionException("Failed to calculate the current number of 'used' resources.", (Exception)e, false);
        }
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

