/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.license;

import com.atlassian.config.ConfigurationException;
import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicensePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdLicenseStore {
    private static final Logger log = LoggerFactory.getLogger(CrowdLicenseStore.class);
    private final LicenseManager licenseManager;
    private AtlassianBootstrapManager bootstrapManager;
    private CrowdLicense license;
    private static final String LICENSE = "license";
    private static final String LICENSE_HASH = "license.hash";
    private static final String LICENSE_MESSAGE = "license.message";

    public CrowdLicenseStore(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public AtlassianLicense getAtlassianLicense(String license) {
        if (license != null) {
            return this.licenseManager.getLicense(license);
        }
        return null;
    }

    public static CrowdLicense getCrowdLicense(AtlassianLicense atlassianLicense) {
        if (atlassianLicense != null) {
            return (CrowdLicense)atlassianLicense.getProductLicense(Product.CROWD);
        }
        return null;
    }

    public CrowdLicense storeLicense(String licenseText) {
        this.getBootstrapManager().setProperty(LICENSE, (Object)licenseText);
        try {
            this.getBootstrapManager().save();
            this.license = null;
        }
        catch (ConfigurationException e) {
            log.error("Failed to set license", (Throwable)e);
        }
        return this.getLicense();
    }

    CrowdLicense getLicense() {
        if (this.license == null) {
            String licenseText = (String)this.getBootstrapManager().getProperty(LICENSE);
            if (licenseText == null) {
                String licenceMessage = (String)this.getBootstrapManager().getProperty(LICENSE_MESSAGE);
                String licenseHash = (String)this.getBootstrapManager().getProperty(LICENSE_HASH);
                try {
                    licenseText = new LicensePair(licenceMessage, licenseHash).getOriginalLicenseString();
                }
                catch (LicenseException e) {
                    log.warn("Could NOT create license pair from license message <" + licenceMessage + "> and license hash <" + licenseHash + ">");
                }
            }
            this.license = CrowdLicenseStore.getCrowdLicense(this.licenseManager.getLicense(licenseText));
        }
        return this.license;
    }

    private AtlassianBootstrapManager getBootstrapManager() {
        if (this.bootstrapManager == null) {
            this.bootstrapManager = BootstrapUtils.getBootstrapManager();
        }
        return this.bootstrapManager;
    }

    void setBootstrapManager(CrowdBootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }
}

