/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.backup;

import com.atlassian.crowd.manager.backup.BackupFileConstants;
import com.google.common.base.Function;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileToTimestampTransformer
implements Function<File, Date> {
    private static final Logger log = LoggerFactory.getLogger(FileToTimestampTransformer.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HHmmss");

    public Date apply(File file) {
        String name = file.getName();
        Matcher matcher = BackupFileConstants.AUTOMATED_BACKUP_FILENAME_PATTERN.matcher(name);
        if (matcher.matches()) {
            String timeStamp = matcher.group(1);
            try {
                return this.dateFormat.parse(timeStamp);
            }
            catch (ParseException e) {
                log.warn("Ignoring backup file with an invalid timestamp {}", (Object)name);
            }
        }
        return null;
    }
}

